package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

import javax.microedition.lcdui.Command;
import com.ibm.ive.midp.MidpMsg;

final class CommandFactory {

	static final int OK_COMMAND = 0;
	static final int CANCEL_COMMAND = 1;
	static final int CLEAR_COMMAND = 2;
	static final int ACTION_COMMAND = 3;
	static final int HISTORY_COMMAND = 4;
	static final int BACK_COMMAND = 5;
	static final int UPDATE_COMMAND = 6;
	static final int PERMISSION_COMMAND = 7;
	static final int INSTALL_COMMAND = 8;
	static final int DELETE_COMMAND = 9;
	static final int LAUNCH_COMMAND = 10;
	static final int DETAILS_COMMAND = 11;
	static final int EXIT_COMMAND = 12;
	static final int LOGIN_COMMAND = 13;
	static final int SELECT_COMMAND = 14;
	static final int SAVE_COMMAND = 15;
	static final int ABOUT_COMMAND = 16;

	static Command gOkCommand;
	static Command gCancelCommand;
	static Command gClearCommand;
	static Command gActionCommand;
	static Command gHistoryCommand;
	static Command gBackCommand;
	static Command gUpdateCommand;
	static Command gPermissionCommand;
	static Command gInstallCommand;
	static Command gDeleteCommand;
	static Command gLaunchCommand;
	static Command gDetailsCommand;
	static Command gExitCommand;
	static Command gLoginCommand;
	static Command gSelectCommand;
	static Command gSaveCommand;
	static Command gAboutCommand;

	static Command getCommand(int cmdType) {
//TODO Refactor the messages to reflect the new hierarchy
		switch (cmdType) {
			case OK_COMMAND:
				if (gOkCommand != null) return gOkCommand;

				return gOkCommand = new Command(MidpMsg.getString("HistoryPage.constructor.command.ok"), Command.OK, 0); //$NON-NLS-1$
			case CANCEL_COMMAND:
				if (gCancelCommand != null) return gCancelCommand;

				return gCancelCommand = new Command(MidpMsg.getString("HistoryPage.constructor.command.cancel"), Command.CANCEL, 0); //$NON-NLS-1$
			case CLEAR_COMMAND:
				if (gClearCommand != null) return gClearCommand;

				return gClearCommand = new Command(MidpMsg.getString("HistoryPage.constructor.command.clear_history"), Command.SCREEN, 0); //$NON-NLS-1$
			case ACTION_COMMAND:
				if (gActionCommand != null) return gActionCommand;

				return gActionCommand = new Command(MidpMsg.getString("InstallPage.buildForm.command.install"), Command.SCREEN, 0); //$NON-NLS-1$
			case HISTORY_COMMAND:
				if (gHistoryCommand != null) return gHistoryCommand;

				return gHistoryCommand = new Command(MidpMsg.getString("InstallPage.buildForm.command.history"), Command.SCREEN, 0); //$NON-NLS-1$
			case BACK_COMMAND:
				if (gBackCommand != null) return gBackCommand;

				return gBackCommand = new Command(MidpMsg.getString("MidletInfoPage.buildForm.command.back"), Command.SCREEN, 0); //$NON-NLS-1$
			case UPDATE_COMMAND:
				if (gUpdateCommand != null) return gUpdateCommand;

				return gUpdateCommand = new Command(MidpMsg.getString("MidletInfoPage.buildForm.command.update"), Command.SCREEN, 0); //$NON-NLS-1$
			case PERMISSION_COMMAND:
				if (gPermissionCommand != null) return gPermissionCommand;

				return gPermissionCommand = new Command(MidpMsg.getString("MidletInfoPage.buildForm.command.permissions"), Command.SCREEN, 0); //$NON-NLS-1$
			case INSTALL_COMMAND:
				if (gInstallCommand != null) return gInstallCommand;

				return gInstallCommand = new Command(MidpMsg.getString("MidletList.constructor.command.install"), Command.SCREEN, 0); //$NON-NLS-1$
			case DELETE_COMMAND:
				if (gDeleteCommand != null) return gDeleteCommand;

				return gDeleteCommand = new Command(MidpMsg.getString("MidletList.rebuildPage.command.delete"), Command.SCREEN, 0); //$NON-NLS-1$
			case LAUNCH_COMMAND:
				if (gLaunchCommand != null) return gLaunchCommand;

				return gLaunchCommand = new Command(MidpMsg.getString("MidletList.rebuildPage.command.launch"), Command.SCREEN, 0); //$NON-NLS-1$
			case DETAILS_COMMAND:
				if (gDetailsCommand != null) return gDetailsCommand;

				return gDetailsCommand = new Command(MidpMsg.getString("MidletList.rebuildPage.command.details"), Command.SCREEN, 0); //$NON-NLS-1$
			case EXIT_COMMAND:
				if (gExitCommand != null) return gExitCommand;

				return gExitCommand = new Command(MidpMsg.getString("MidletList.constructor.command.exit"), Command.SCREEN, 1); //$NON-NLS-1$
			case LOGIN_COMMAND:
				if (gLoginCommand != null) return gLoginCommand;

				return gLoginCommand = new Command(MidpMsg.getString("NamePasswordPrompt.getDisplayable.command.login"), Command.OK, 0); //$NON-NLS-1$
			case SELECT_COMMAND:
				if (gSelectCommand != null) return gSelectCommand;

				return gSelectCommand = new Command(MidpMsg.getString("PermissionsList.constructor.command.select"), Command.ITEM, 1); //$NON-NLS-1$
			case SAVE_COMMAND:
				if (gSaveCommand != null) return gSaveCommand;

				return gSaveCommand = new Command(MidpMsg.getString("PermissionsPage.buildForm.command.save"), Command.SCREEN, 0); //$NON-NLS-1$
			case ABOUT_COMMAND:
				if (gAboutCommand != null) return gAboutCommand;

				return gAboutCommand = new Command(MidpMsg.getString("MidletList.constructor.command.about"), Command.SCREEN, 1); //$NON-NLS-1$
			default:
				/* should not happen */
				return new Command(Integer.toString(cmdType), Command.SCREEN, 0);
		}
	}
}
