package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;
import com.ibm.ive.midp.ams.*;
import com.ibm.ive.midp.util.*;
import javax.microedition.lcdui.*;

public class DisplayBasedInstallListener implements IInstallProcessListener, CommandListener {

	Gauge fGauge;
	Display fDisplay;
	Displayable fSuccessPage;
	Displayable fFailPage;
	boolean fCancelled = false;

	public DisplayBasedInstallListener(Displayable successPage, Displayable failPage, Display display) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		fDisplay = display;
		fSuccessPage = successPage;
		fFailPage = failPage;
	}

	public boolean isOkToInstallFromUntrustedSource(MidletEntry midlet) {
		return promptUser(MidpMsg.getString("ActionStatus.promptForAnswer.untrusted_midlet"));				 //$NON-NLS-1$
	}

	public boolean isOkToUpdateFile(MidletEntry midlet, int code) {
		String message = null;
		switch (code) {
			case MidpConstants.PROMPT_SAME_VERSION_EXISTS | MidpConstants.PROMPT_DIFFERENT_LOCATION:
			case MidpConstants.PROMPT_SAME_VERSION_EXISTS: {
				message = MidpMsg.getString("ActionStatus.promptForAnswer.same_version_exists"); //$NON-NLS-1$
				break;
			}
			case MidpConstants.PROMPT_EARLIER_VERSION_EXISTS | MidpConstants.PROMPT_DIFFERENT_LOCATION:
			case MidpConstants.PROMPT_EARLIER_VERSION_EXISTS: {
				message = MidpMsg.getString("ActionStatus.promptForAnswer.older_version_exists"); //$NON-NLS-1$
				break;
			}
			case MidpConstants.PROMPT_LATER_VERSION_EXISTS | MidpConstants.PROMPT_DIFFERENT_LOCATION:
			case MidpConstants.PROMPT_LATER_VERSION_EXISTS: {
				message = MidpMsg.getString("ActionStatus.promptForAnswer.newer_version_exists"); //$NON-NLS-1$
				break;
			}
		}
		return promptUser(message);
	}

	boolean promptUser(String message) {
		QuestionPrompt r = new QuestionPrompt(MidpMsg.getString("ActionStatus.promptForAnswer.title"), message); //$NON-NLS-1$
		r.addResponse(MidpMsg.getString("ActionStatus.promptForAnswer.no"),1, 1); //$NON-NLS-1$
		r.addResponse(MidpMsg.getString("ActionStatus.promptForAnswer.yes"), 0, 0); //$NON-NLS-1$
		int returnValue = r.openPrompt(fDisplay);
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	}
/* To make the installStatusAlert modal. Else the alert is never seen */
	boolean notifyUser(String title, String message) {
		QuestionPrompt r = new QuestionPrompt(title, message); //$NON-NLS-1$
		r.fAlert.setType(AlertType.INFO);
		r.addResponse(MidpMsg.getString("reNamePrompt.getDisplayable.command.ok"), 0, 0); //$NON-NLS-1$
		int returnValue = r.openPrompt(fDisplay);
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	}

	public boolean isOkToInstallFile(MidletEntry midlet) {
		long size = 0;
		try {
			size += Integer.parseInt(midlet.getJarSize());
		} catch (NumberFormatException nfe) {
			// do nothing
		}
		try {
			String dataSizeString = midlet.getDataSize();
			if (dataSizeString != null) size += Long.parseLong(dataSizeString);
		} catch (NumberFormatException nfe) {
			// do nothing
		}
		return promptUser(MidpMsg.getString("ActionStatus.promptForAnswer.midlet_details", new String[] //$NON-NLS-1$
			{midlet.getName(), midlet.getVersion(), Long.toString(size), midlet.getVendor()}));
	}

	public void installSucceeded(MidletEntry entry, boolean isAnUpdate, boolean platformInstallProcess) {
		/* Update the midlet page to reflect the newly installed midlet. */
		AmsMidlet.getMidletList(fDisplay).rebuildPage();
		String successMesg;
		if (isAnUpdate){
			successMesg = MidpMsg.getString("ActionStatus.installSucceded.update.message", entry.getName()); //$NON-NLS-1$
		} else {
			successMesg = MidpMsg.getString("ActionStatus.installSucceded.install.message", entry.getName()); //$NON-NLS-1$
		}
		if (platformInstallProcess) {
			notifyUser(MidpMsg.getString("ActionStatus.installSucceded.title"), successMesg); //$NON-NLS-1$
			ModalPrompt.callHiddenSetCurrentImpl(fDisplay, fSuccessPage);
		}
		else {
			if (entry.getMIDletNames().length < 1) {
				notifyUser(MidpMsg.getString("ActionStatus.installSucceded.title"), successMesg); //$NON-NLS-1$
			} else if (isOkToLaunchInstalledMidlet(entry.getName(), successMesg)) {
				((MidletList)fSuccessPage).launchMidlet(entry);
			}
			fDisplay.setCurrent(fSuccessPage);
		}
	}

	public void installFailed(AmsException reason) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();

		// If the user cancelled the process then it is overkill to remind them
		// that they cancelled
		if (reason.getStatus() != MidpConstants.RET_OPERATION_CANCELLED) {
			notifyUser(MidpMsg.getString("ActionStatus.installFailed.error.title"), reason.getMessage());
		}
		ModalPrompt.callHiddenSetCurrentImpl(fDisplay, fFailPage);
	}

	public boolean isCancelled() {
		return fCancelled;
	}

	public void notifyDownloadProgress(int bytesDownloaded, int totalSizeInBytes) {
		// Make sure that the total value for this gauge is correct
		if (fGauge.getMaxValue() != totalSizeInBytes) fGauge.setMaxValue(totalSizeInBytes);
		// Update the current position along the gaguge
		fGauge.setValue(bytesDownloaded);
	}

	public void notifyDownloadFinished(int totalSizeInBytes) {
		fGauge.setValue(fGauge.getMaxValue());
	}

	public long getAvailableStorageSpace() {
		return FileStorage.getAvailableStorageSpace();
	}

	public String[] getUserNameAndPassword(String realm) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		NamePasswordPrompt prompt = new NamePasswordPrompt(realm);
		return prompt.openPrompt(fDisplay);
	}

	public Displayable showProgressUI(String message) {
		Displayable d = createDisplayable(message);
		ModalPrompt.callHiddenSetCurrentImpl(fDisplay, d);
		return d;
	}

	protected Displayable createDisplayable(String message) {
		Form form = new Form(MidpMsg.getString("ActionStatus.createWidgets.title")); //$NON-NLS-1$
		form.append(message);

		fGauge = new Gauge(MidpMsg.getString("ActionStatus.createWidgets.progress.label"), false, 10,0); //$NON-NLS-1$
		form.append(fGauge);

		Command cancelCommand = new Command(MidpMsg.getString("ActionStatus.createWidgets.command.cancel"), Command.CANCEL, 0); //$NON-NLS-1$
		form.addCommand(cancelCommand);
		form.setCommandListener(this);

		return form;
	}

	public boolean isOkToRenameFile(MidletEntry midlet) {
		return promptUser(MidpMsg.getString("ActionStatus.promptForAnswer.rename", midlet.getName()));
	}

	public boolean isOkToRetainRMS(String midlet) {
		return promptUser(MidpMsg.getString("ActionStatus.promptForAnswer.retainRMS", midlet));
	}

	public boolean isOkToUpdateDifferentPrincipal(String midlet) {
		return promptUser(MidpMsg.getString("ActionStatus.promptForAnswer.differentPrincipal", midlet));
	}

	public boolean isOkToLaunchInstalledMidlet(String midlet, String message) {
		return promptUser(message + MidpMsg.getString("ActionStatus.promptForAnswer.launchMidlet", midlet));
	}

	public String getNewFileName(MidletEntry midlet) {
		RenamePrompt prompt = new RenamePrompt();
		return prompt.getName(fDisplay);
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand.getCommandType() == Command.CANCEL) {
			fCancelled = true;
			fDisplay.setCurrent(fFailPage);
		}
	}
}
