package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import javax.microedition.lcdui.*;
import com.ibm.ive.midp.*;
import com.ibm.ive.midp.ams.*;

public class HistoryPage extends List implements CommandListener {

	Display fDisplay;
	Displayable fPreviousDisplayable;
	TextField fLocationEntry;

	public HistoryPage(Display display, Displayable previous, TextField locationEntry) {
		super(MidpMsg.getString("HistoryPage.constructor.title"), Choice.IMPLICIT, InstallHistory.getHistory(), null); //$NON-NLS-1$
		fDisplay = display;
		fPreviousDisplayable = previous;
		fLocationEntry = locationEntry;

		addCommand(CommandFactory.getCommand(CommandFactory.OK_COMMAND));
		addCommand(CommandFactory.getCommand(CommandFactory.CANCEL_COMMAND));
		addCommand(CommandFactory.getCommand(CommandFactory.CLEAR_COMMAND));

		setCommandListener(this);
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gOkCommand || aCommand == List.SELECT_COMMAND) {
			int index = getSelectedIndex();
			if (index >= 0) fLocationEntry.setString(getString(index));
			fDisplay.setCurrent(fPreviousDisplayable);
		} else if (aCommand == CommandFactory.gCancelCommand) {
			fDisplay.setCurrent(fPreviousDisplayable);
		} else if (aCommand == CommandFactory.gClearCommand) {
			InstallHistory.clear();
			deleteAll();
		}
	}
}
