package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import javax.microedition.lcdui.*;
import com.ibm.ive.midp.ams.*;
import com.ibm.ive.midp.MidpMsg;

class InstallPage extends Form implements CommandListener, ItemStateListener {

	TextField fLocationEntry;
	ChoiceGroup fCompletions;
	static final String[] COMPLETIONS = {"...","http://","www.",".com",".net",".org","/"}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

	MidletList fMidletList;
	Display fDisplay;

	public InstallPage(Display display, MidletList list) {
		super(MidpMsg.getString("InstallPage.constructor.title")); //$NON-NLS-1$
		fDisplay = display;
		fMidletList = list;
		buildForm();
	}

	void buildForm() {
		append(new StringItem(null, MidpMsg.getString("InstallPage.buildForm.instructions.message"))); //$NON-NLS-1$

		append(fLocationEntry = new TextField("URL:", null, 1000, TextField.ANY)); //$NON-NLS-1$

		append(fCompletions = new ChoiceGroup(null,Choice.POPUP,COMPLETIONS, null));
		setItemStateListener(this);

		addCommand(CommandFactory.getCommand(CommandFactory.ACTION_COMMAND));
		addCommand(CommandFactory.getCommand(CommandFactory.CANCEL_COMMAND));
		addCommand(CommandFactory.getCommand(CommandFactory.HISTORY_COMMAND));
		setCommandListener(this);
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gCancelCommand) {
			fDisplay.setCurrent(fMidletList);
		} else if (aCommand == CommandFactory.gActionCommand) {
			startInstallProcess();
		} else if (aCommand == CommandFactory.gHistoryCommand) {
			if (InstallHistory.isEmpty()) {
				Alert historyEmpty = new Alert(MidpMsg.getString("InstallPage.commandAction.empty.history.title"), //$NON-NLS-1$
											   MidpMsg.getString("InstallPage.commandAction.empty.history.message"), null, AlertType.INFO); //$NON-NLS-1$
				fDisplay.setCurrent(historyEmpty);
			} else {
				HistoryPage historyPage = new HistoryPage(fDisplay, aDisplayable, fLocationEntry);
				fDisplay.setCurrent(historyPage);
			}
		}
	}

	void startInstallProcess() {
		/* Set up the install process */
		DisplayBasedInstallListener listener = new DisplayBasedInstallListener(fMidletList, this, fDisplay);
		InstallProcess process = new InstallProcess(fLocationEntry.getString(), MidpConstants.INSTALL_MIDLET, listener, false);
		listener.showProgressUI(MidpMsg.getString("InstallPage.startInstallProcess.message", fLocationEntry.getString())); //$NON-NLS-1$

		/* Run the install process in the seperate thread so that the ui is not blocked
		   and the user has the ability to press cancel */
		new Thread(process).start();
	}

	public void itemStateChanged(Item anItem) {
		if (anItem == fCompletions) {
			int selected = fCompletions.getSelectedIndex();
			if (selected != 0) {
				String text = fCompletions.getString(selected);
				fLocationEntry.insert(text, fLocationEntry.size());
			}
			fDisplay.setCurrentItem(fLocationEntry);
		}
	}
}
