package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import javax.microedition.lcdui.*;
import com.ibm.ive.midp.MidpMsg;

public class NamePasswordPrompt extends ModalPrompt implements CommandListener {

	String fRealm;
	TextField fUserField;
	TextField fPasswordField;

	boolean fCanceled;

	public NamePasswordPrompt(String realm) {
		fRealm = realm;
	}

	protected Displayable getDisplayable() {
		Form form = new Form(MidpMsg.getString("NamePasswordPrompt.getDisplayable.title")); //$NON-NLS-1$
		form.append(MidpMsg.getString("NamePasswordPrompt.getDisplayable.message", fRealm)); //$NON-NLS-1$

		fUserField = new TextField(MidpMsg.getString("NamePasswordPrompt.getDisplayable.username"), "", 50, TextField.ANY); //$NON-NLS-1$ //$NON-NLS-2$
		form.append(fUserField);

		fPasswordField = new TextField(MidpMsg.getString("NamePasswordPrompt.getDisplayable.password"), "", 50, TextField.PASSWORD); //$NON-NLS-1$ //$NON-NLS-2$
		form.append(fPasswordField);

		form.addCommand(CommandFactory.getCommand(CommandFactory.LOGIN_COMMAND));
		form.addCommand(CommandFactory.getCommand(CommandFactory.CANCEL_COMMAND));

		form.setCommandListener(this);
		return form;
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gCancelCommand) fCanceled = true;

		unlock();
	}

	public String[] openPrompt(Display display) {
		fCanceled = false;

		super.showDialog(display);

		if (fCanceled) return null;

		String[] results = new String[2];
		results[0] = fUserField.getString();
		results[1] = fPasswordField.getString();
		return results;
	}
}
