package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import javax.microedition.lcdui.*;
import com.ibm.ive.midp.*;
import com.ibm.ive.midp.ams.*;
import com.ibm.oti.midlet.help.*;
import com.ibm.oti.security.midp.*;

class PermissionsPage extends Form implements CommandListener, IMIDletPermissions {

	String fMidletName;
	String fMidletVendor;
	Display fDisplay;
	Displayable fPreviousDisplayable;
	ProtectionDomain fDomain;
	String fPermission;
	String fDomainName;
	PermissionsGroupChoice group;
	static final Font gBoldFont = Font.getFont(Font.FACE_SYSTEM,Font.STYLE_BOLD,Font.SIZE_MEDIUM);

	/**
	 * Create the permissions page
	 * @param display - device's display
	 * @param previous - displayable that will be redisplayed upon completion
	 * @param midlet - MidletEntry describing the midlet whose permissions are changing
	 */
	public PermissionsPage(Display display, Displayable previous, MidletEntry midletEntry, String Perm) {
		super(MidpMsg.getString("PermissionsPage.constructor.title")); //$NON-NLS-1$

		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) {
			throw new SecurityException();
		}

		fDisplay = display;
		fPreviousDisplayable = previous;
		fPermission = Perm;
		fDomainName = midletEntry.getSecurityDomain();
		fDomain = SecurityPolicy.getInstance().getProtectionDomain(fDomainName);
		fMidletName = midletEntry.getName();
		fMidletVendor = midletEntry.getVendor();

		buildForm();
	}

	void buildForm() {
		// Make sure the form is completely empty
		deleteAll();

		buildChoices();
		if (group.fAllowedPermission || group.fDeniedPermission) {
			addCommand(CommandFactory.getCommand(CommandFactory.BACK_COMMAND));
		} else {
			addCommand(CommandFactory.getCommand(CommandFactory.SAVE_COMMAND));
			addCommand(CommandFactory.getCommand(CommandFactory.CANCEL_COMMAND));
		}
		setCommandListener(this);
	}

	void buildChoices() {
		// get permissions for this domain from the security policy
		group = new PermissionsGroupChoice(fPermission);
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gCancelCommand || aCommand == CommandFactory.gBackCommand) {
			handleCancel();
		} else if (aCommand == CommandFactory.gSaveCommand) {
			handleSave();
		}
	}

	void handleCancel() {
		returnToPreviousDisplayable();
	}

	void returnToPreviousDisplayable() {
		fDisplay.setCurrent(fPreviousDisplayable);
	}

	void handleSave() {
		if (group != null) group.saveUserChoices();
		returnToPreviousDisplayable();
	}

	class PermissionsGroupChoice {
		FastVector fPermissions;
		int fDefaultPermission;
		int fHighestPermission;

		boolean fAllowedPermission = false;
		boolean fDeniedPermission = false;
		int fQuestionNumber;

		PermissionsGroupChoice(String permission) {
			init(permission);
			String question = PermissionMsg.getString(INTERACTION_MSG + permission, new String[]{fMidletName});
			addChoiceGroup(question);
		}

		void init(String permission) {
			fDefaultPermission = fDomain.getDefaultPermissionLevel(permission);

			fHighestPermission =fDomain.getHighestPermissionLevel(permission);
			if (fHighestPermission == ProtectionDomain.PERMISSION_LEVEL_ALLOW)
				fAllowedPermission = true;
			if (fHighestPermission == ProtectionDomain.PERMISSION_LEVEL_DENY)
				fDeniedPermission = true;
			fPermissions = new FastVector();
			fPermissions.addElement(permission);
		}

		public boolean addPermission(String permission) {
			int defaultPermission = fDomain.getDefaultPermissionLevel(permission);
			int highestPermission = fDomain.getHighestPermissionLevel(permission);
			if (defaultPermission == fDefaultPermission && highestPermission == fHighestPermission) {
				fPermissions.addElement(permission);
				return true;
			}
			return false;
		}

		void addChoiceGroup(String question) {
			// allowed and denied permission in the security policy to not require
			// any user interaction
			if (fAllowedPermission || fDeniedPermission) {
				StringItem strItem = new StringItem(null, MidpMsg.getString("PermissionsList.PermissionsGroupChoice.addChoiceGroup.DefaultPermissionMessage", new Object[] {fMidletName, fDomainName}));//$NON-NLS-1$
				append(strItem);
				return;
			}

			// the least number of choices they could ever choose from
			String[] choices = new String[ONESHOT_RESPONSES];
			// don't give them any more choices than their allowed highest permission
			if (fHighestPermission == ProtectionDomain.PERMISSION_LEVEL_USER_BLANKET) {
				choices = new String[BLANKET_RESPONSES];
				choices[BLANKET] = PermissionMsg.getString(INTERACTION_BLANKET_MSG);
				choices[SESSION] = PermissionMsg.getString(INTERACTION_SESSION_MSG);
			} else if (fHighestPermission ==ProtectionDomain.PERMISSION_LEVEL_USER_SESSION) {
				choices = new String[SESSION_RESPONSES];
				choices[SESSION] = PermissionMsg.getString(INTERACTION_SESSION_MSG);
			}
			choices[DENY] = PermissionMsg.getString(INTERACTION_DENY_MSG);
			choices[ONESHOT] = PermissionMsg.getString(INTERACTION_ONESHOT_MSG);

			// the choice to preselect for the user
			int defaultSelection = 0;

			MidletSuiteId suiteId = new MidletSuiteId(fMidletName, fMidletVendor);
			String userInteraction = MidletLoader.getMetadataEntry(suiteId, METADATA_CLASSNAME, fPermission);

			if (userInteraction != null && userInteraction.length() > 0) {
				defaultSelection = Integer.parseInt(userInteraction);
			} else {
				switch (fDefaultPermission) {
					case ProtectionDomain.PERMISSION_LEVEL_USER_BLANKET:
						defaultSelection = BLANKET;
						break;
					case ProtectionDomain.PERMISSION_LEVEL_USER_SESSION:
						defaultSelection = SESSION;
						break;
					case ProtectionDomain.PERMISSION_LEVEL_USER_ONESHOT:
						defaultSelection = ONESHOT;
						break;
				}
			}

			/*
			 * Use a StringItem instead of the item's label since the item's label might be truncated
			 */
			StringItem item = new StringItem(null, question);
			item.setFont(gBoldFont);
			append(item);
			ChoiceGroup choice = new ChoiceGroup(null, Choice.EXCLUSIVE, choices, null);
			choice.setSelectedIndex(defaultSelection, true);
			fQuestionNumber = append(choice);
		}

		public void saveUserChoices() {
			// user interaction is not requeired for allowed permissions
			if (fAllowedPermission || fDeniedPermission) return;

			ChoiceGroup choice = (ChoiceGroup) get(fQuestionNumber);
			int selectedIndex = choice.getSelectedIndex();

			// setting the current mode of a permission to 0 ensures that the
			// user is prompted
			int selectedMode = 0;
			if (selectedIndex == DENY) {
				selectedMode = UserPermissionAgent.MODE_DENY_ALWAYS;
			} else if (selectedIndex == BLANKET) {
				selectedMode = UserPermissionAgent.MODE_GRANT_ALWAYS;
			}

			MidletSuiteId suiteId = new MidletSuiteId(fMidletName, fMidletVendor);
			String userInteraction = MidletLoader.getMetadataEntry(suiteId, METADATA_CLASSNAME, fPermission);

			// save the user's selected default interaction mode (when it is
			// not the same as the previously selected default interaction
			if (userInteraction == null || selectedIndex != Integer.parseInt(userInteraction)) {
				MidletLoader.setMetadataEntry(
					suiteId,
					METADATA_CLASSNAME,
					fPermission,
					Integer.toString(selectedIndex));
			}

			// set the mode for PermissionManager to use later
			int previousMode = MidletLoader.getPermissionMode(suiteId,  fPermission);
			if (selectedMode != previousMode) {
				MidletLoader.setPermissionMode(suiteId,  fPermission, selectedMode);
			}
		}
	}
}
