package com.ibm.ive.midp.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2005  All Rights Reserved
 */

import java.io.*;
import javax.microedition.io.*;
import com.ibm.oti.connection.*;
import com.ibm.oti.connection.file.FileInputStream;

/*
 * Including FileConnector support as it is not part of the
 * JCL stream anymore
 */

/**
 * Implements a file connection. Accepts the following parameters:
 * <UL>
 * <LI>append - true/false, append to an existing file, only valid when writing,
 * the default is false which will overwrite an existing file</LI>
 * </UL>
 *
 * @author		OTI
 * @version		initial
 *
 * @see		javax.microedition.io.InputConnection
 * @see		javax.microedition.io.OutputConnection
 */
public class FileConnection implements InputConnection, CreateConnection {
	private String name;
	private int access;
	private boolean append = false;

	public FileConnection() {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
	}

	/**
	 * Passes the parameters from the Connector.open() method to this
	 * object. Protocol used by MIDP 2.0
	 *
	 * @author		OTI
	 * @version		initial
	 *
	 * @param		spec String
	 *					The address passed to Connector.open()
	 * @param		access int
	 *					The type of access this Connection is
	 *					granted (READ, WRITE, READ_WRITE)
	 * @param		timeout boolean
	 *					A boolean indicating whether or not the
	 *					caller to Connector.open() wants timeout
	 *					exceptions
	 * @exception	IOException
	 *					If an error occured opening and configuring
	 *					serial port.
	 *
	 * @see javax.microedition.io.Connector
	 */
	public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
		setParameters(spec, access, timeout);
		return this;
	}

	/**
	 * Passes the parameters from the Connector.open() method to this
	 * object. Protocol used by MIDP 1.0
	 *
	 * @author		OTI
	 * @version		initial
	 *
	 * @param		spec String
	 *					The address passed to Connector.open()
	 * @param		access int
	 *					The type of access this Connection is
	 *					granted (READ, WRITE, READ_WRITE)
	 * @param		timeout boolean
	 *					A boolean indicating whether or not the
	 *					caller to Connector.open() wants timeout
	 *					exceptions
	 * @exception	IOException
	 *					If an error occured opening and configuring
	 *					serial port.
	 *
	 * @see javax.microedition.io.Connector
	 */
	public void setParameters(String spec, int access, boolean timeout) throws IOException {
		String[][] equates = ConnectionUtil.NO_PARAMETERS;
		int index = spec.indexOf(';');
		if (index != -1) {
			equates = ConnectionUtil.getParameters(spec.substring(index + 1));
			spec = spec.substring(0, index);
		}
		setParameters(spec, equates, access, timeout);
	}

	/**
	 * Passes the parameters from the Connector.open() method to this
	 * object.
	 *
	 * @author		OTI
	 * @version		initial
	 *
	 * @param		spec String
	 *					The address passed to Connector.open()
	 * @param		equates String[][]
	 *					An 2-dimensional array of strings that
	 *					contain the parameters and their keys
	 *					passed to Connector.open()
	 * @param		access int
	 *					The type of access this Connection is
	 *					granted (READ, WRITE, READ_WRITE)
	 * @param		throwTimeout boolean
	 *					A boolean indicating whether or not the
	 *					caller to Connector.open() wants timeout
	 *					exceptions
	 * @exception	IOException
	 *					If an error occured opening and configuring
	 *					serial port.
	 *
	 * @see javax.microedition.io.Connector
	 */
	public void setParameters(String spec, String[][] equates, int access, boolean timeout) throws IOException {
		int idx = 0;
		if (spec.startsWith("//")) { //$NON-NLS-1$
			boolean found = false;
			int length = spec.length();
			for (idx=2; idx<length; idx++) {
				char ch;
				if ((ch = spec.charAt(idx)) == '/' || ch == '\\') {
					found = true;
					break;
				} else if (ch == ':' || ch == ' ') break;
			}
			if (!found) throw new IllegalArgumentException(spec);
		}
		if (idx == 2) name = spec.substring(2);
		else name = spec;
		this.access = access;
		for (int i=0; i<equates.length; i++) {
			String key = equates[i][0].toLowerCase();
			if (key.equals("append") && equates[i][1] != null) { //$NON-NLS-1$
				String value = equates[i][1].toLowerCase();
				if (value.equals("true")) append = true; //$NON-NLS-1$
				else if (!value.equals("false")) //$NON-NLS-1$
					throw new IllegalArgumentException(com.ibm.oti.util.Msg.getString("K00b5")); //$NON-NLS-1$
			} else throw new IllegalArgumentException(com.ibm.oti.util.Msg.getString("K00a5", equates[i][0])); //$NON-NLS-1$
		}

		StringBuffer result = new StringBuffer();
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		for (int i = 0; i < name.length();) {
			char c = name.charAt(i);
			if (c == '%') {
				out.reset();
				do {
					if (i + 2 >= name.length())
						throw new IllegalArgumentException("Incomplete % sequence at: " + i);
					int d1 = Character.digit(name.charAt(i+1), 16);
					int d2 = Character.digit(name.charAt(i+2), 16);
					if (d1 == -1 || d2 == -1)
						throw new IllegalArgumentException("Invalid % sequence (" + name.substring(i, i+3) + ") at: " + i);
					out.write((byte)((d1 << 4) + d2));
					i += 3;
				} while (i < name.length() && name.charAt(i) == '%');
				result.append(out.toString());
				continue;
			} else result.append(c);
			i++;
		}
		name = result.toString();

	}

	public void close() throws IOException {
		name = null;
	}

	public DataInputStream openDataInputStream() throws IOException {
		return new DataInputStream(openInputStream());
	}

	public InputStream openInputStream() throws IOException {
		if (name == null) throw new IOException(com.ibm.oti.util.Msg.getString("K00ac")); //$NON-NLS-1$
		if (access != Connector.READ && access != Connector.READ_WRITE)
			throw new IOException(com.ibm.oti.util.Msg.getString("K00a9")); //$NON-NLS-1$
		return new FileInputStream(name);
	}
}
