package com.ibm.ive.midp.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

import java.util.Random;

public class FileStorage {

	protected static final String USER_HOME = System.getProperty("user.home"); //$NON-NLS-1$
	protected static final String SERARATOR = System.getProperty("file.separator"); //$NON-NLS-1$

	static Random rand = new Random();
	public static int getRandomInt(int from, int to) {
		int j;
		j = rand.nextInt();
		if (j < 0) j = -j;
		j = j % (to - from + 1);
		return j + from;
	}

	public static String getNextAvailableFileId() {
		String alpha = "ABCDEFGHJKLMNPQRSTUVWXYZ"; //$NON-NLS-1$
		int m1 = getRandomInt(0, alpha.length() - 1);
		int m2 = getRandomInt(0, alpha.length() - 1);
		return alpha.substring(m1, m1 + 1) + System.currentTimeMillis() + alpha.substring(m2, m2 + 1);
	}

	public static String getNextAvailableFileName(String extension) {
		String fileID = getNextAvailableFileId();
		return getNextAvailableFileName(fileID, extension);
	}

	public static String getNextAvailableFileName(String id, String extension) {
		return USER_HOME + SERARATOR + "temp" + SERARATOR + id + extension;
	}

	public native static long getAvailableStorageSpace();

	public static boolean delete(String fileName) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		return deleteImpl(fileName);
	}
	static native boolean deleteImpl(String fileName);

	public static void rename(String oldFileName, String newFileName) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		renameImpl(oldFileName, newFileName);
	}
	static native void renameImpl(String oldFileName, String newFileName);
}
