package com.ibm.ive.midp.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

import java.io.*;

public class IOUtil {

	public static byte[] getByteArray(InputStream is) throws IOException {
		int available = is.available();
		if (available == 0) available = 1024;

		byte[] buffer = new byte[available];
		int loc = 0;
		int len;
		while ((len = is.read(buffer, loc, buffer.length - loc)) != -1) {
			if (len == 0) { // buffer.length was equal to loc
				if (buffer.length == Integer.MAX_VALUE) throw new IOException(); // image larger than a byte array can hold
				int newLen = buffer.length*2;
				if (newLen <= buffer.length) newLen = Integer.MAX_VALUE; // use max value in case of overflow
				byte[] newArray = new byte[newLen];
				System.arraycopy(buffer, 0, newArray, 0, loc);
				buffer = newArray;
			} else {
				loc += len;
			}
		}
		if (loc == buffer.length) return buffer;

		byte[] retArray = new byte[loc];
		System.arraycopy(buffer, 0, retArray, 0, loc);
		return retArray;
	}
}
