package com.ibm.ive.midp.util;

import com.ibm.ive.midp.Device;
import com.ibm.ive.midp.ams.MidletEntry;
import com.ibm.oti.midlet.help.MidletLoader;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

/*
 * Handles calls to MIDlet.platformRequest() based on the
 * Device and its settings.
 */
public class ProgramLauncher {

	/*
	 * Launch Program
	 * @param programName  - fully qualified programName
	 * @param programArgs  - program (command line) Arguments
	 * @param wait         - synchronous(wait=true) / asynchronous(wait=false)
	 */
	public static int launchProgram(String programName, String programArgs, MidletEntry entry, boolean wait) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();

		Device.midletSuiteClosing();
		String midletIdentifier = null;
		if (entry != null) {
			if (entry.isMidp10()) midletIdentifier = entry.getName() + entry.getVendor();
		}

		int result = NativeLaunch(programName, programArgs, midletIdentifier, wait ? 1 : 0);

		//close the mutex handle (if any) created while launching the midlet.
		if (midletIdentifier != null) Device.closeMidletIdentifier();

		if (!Device.isAllowedToRunMIDletSuite()) {
			new Exception().printStackTrace();
		}
		MidletLoader.refresh();
		return result;
	}

	static private native synchronized int NativeLaunch(String programName, String programArgs, String midletName, int wait);
}
