package com.ibm.microedition.media;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import java.io.*;
import java.util.*;

/**
 *
 * This class is the superclass for all the specific media players.  It extends
 * the MediaPlayer that provides implementation for all the methods specified in
 * Player interface.  It also declares some protected variables that will be used
 * by all the players.
 *
 */

public abstract class ExtendedMediaPlayer extends MediaPlayer {

	protected int               fHandle;
	protected byte[]            fData;
	protected Vector            fListeners;
	protected boolean           fExplicitlyStopped;
	protected int               fMediaTime;
	protected boolean           fInterruptReadingData;
	protected Object            fCloseMutex;
//	protected Object            fStartedEvent;

	protected ExtendedMediaPlayer() {
		fHandle               = 0;
		fListeners            = new Vector(1);
		fExplicitlyStopped    = false;
		fMediaTime            = 0;
		fInterruptReadingData = false;
		fCloseMutex           = new Object();
//		fStartedEvent         = new Object();
	}

	/**
	* Reads data from the media descriptor
	*/
	protected boolean readData() throws IOException {
		byte[] buffer = new byte[16000];
		int bytesRead = 0;
		MediaDescriptor md = this.getMediaDescriptor();
		InputStream stream = md.getMediaIS();

		ByteArrayOutputStream baoStream = new ByteArrayOutputStream(16000);
		byte[] temp = md.getHeader();

		if (null != temp) {
			baoStream.write(temp, 0, temp.length);
			md.setHeader(null);
		}

		while ((bytesRead = stream.read(buffer)) >= 0) {
			baoStream.write(buffer, 0, bytesRead);
		}
		fData = baoStream.toByteArray();
		stream.close();

		if (fData != null)
			return true;

		return false;
	}
}
