package com.ibm.microedition.media;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import java.io.IOException;

import javax.microedition.media.*;
import javax.microedition.media.control.ToneControl;

import com.ibm.ive.midp.MidpMsg;

/**
 * Specific implementation of the playTone method in Manager.
 */
public class PlayToneImpl {

//	native private static int nPlayTone(int note, int dur, int vol);
	static public Player oldPlayer;

	/**
	 * This can be replaced with different implementation.
	 * Checking is already done in Manager class.
	 *
	 * @param note
	 * @param duration
	 * @param volume
	 * @throws MediaException
	 */
	static public void playToneImpl(int note, int duration, int volume)
		throws MediaException {

		//Native implementation comes here
		//if (nPlayTone(note, duration, volume) <= 0)
		//	throw new MediaException("Error playing the specifid tone!");

		// or defer to playToneAsToneSequence() method below
		playToneAsToneSequence(note, duration, volume);
	}

	/**
	 * Convenience method to use TonePlayer if no simple playTone exists.
	 *
	 * @param note
	 * @param duration
	 * @param volume
	 * @throws MediaException
	 */
	static public void playToneAsToneSequence(int note, int duration, int volume)
		throws MediaException	{

		/*use the ToneControl to play the note
		 *set tempo to 60 BPM, resolution to 1/40th notes
		 *this means each duration unit is 0.1 seconds
		 *this means maximum duration is 127 * 0.1 = 12.7 seconds
		 */
		 if (oldPlayer != null) {
			oldPlayer.close();
			oldPlayer = null;
		 }

		 Player player;
		 try {
			 player = Manager.createPlayer(Manager.TONE_DEVICE_LOCATOR);
		 } catch (IOException e) {
			 throw new MediaException(MidpMsg.getString("Manager.playTone.MediaException")); //$NON-NLS-1$
		 }
		 oldPlayer = player;

		 player.realize();
		 ToneControl toneControl = (ToneControl) player.getControl("ToneControl"); //$NON-NLS-1$

		 if (duration > 12700) duration = 12700;
		 duration /= 100;
		 if (duration <= 0) duration = 1;

		 byte[] sequence = {
			 ToneControl.VERSION,     1,            // set version    = 1
			 ToneControl.TEMPO,      15,            // set tempo      = 60 BPM
			 ToneControl.RESOLUTION, 40,            // set resolution = 1/40th notes
			 ToneControl.SET_VOLUME, (byte) volume, // set volume
			 (byte) note, (byte) duration           // note and duration
		 };

		 PlayerListener playerListener = new PlayerListener() {
			 public void playerUpdate(Player player, String event, Object eventData) {
				 if (!event.equals(PlayerListener.END_OF_MEDIA)) return;
				 player.close();
			 }
		 };

		 player.addPlayerListener(playerListener);
		 toneControl.setSequence(sequence);
		 player.start();
		}
}
