package com.ibm.microedition.media.control;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import javax.microedition.media.control.ToneControl;
import com.ibm.microedition.media.MIDICompiler;
import com.ibm.microedition.media.MediaPlayer;

/**
 *
 * Implements the ToneControl interface
 */
public class ToneCtrl implements ToneControl {

	private MediaPlayer fPlayer;
	private int[] fMidiSequence = null;

	public ToneCtrl(MediaPlayer player) {
		super();
		fPlayer = player;
	}

	/*
	 *  compile the byte sequence to Midi format for playing.
	 */
	public synchronized void setSequence(byte[] sequence) {
		fPlayer.evaluateOperation(MediaPlayer.OPERATION_SETSEQUENCE);
		if (null == sequence || 0 == sequence.length) {
			throw new IllegalArgumentException(MediaPlayer.getTranslatedString("MIDICompiler.msg1")); //$NON-NLS-1$
		}
		fPlayer.evaluateOperation(MediaPlayer.OPERATION_SETSEQUENCE);
		fMidiSequence = MIDICompiler.compileToMidi(sequence, 0, 0);
		if (null == fMidiSequence) {
			throw new IllegalArgumentException(MediaPlayer.getTranslatedString("MIDICompiler.msg3")); //$NON-NLS-1$
		}
	}

	/*
	 * returns the compiled byte sequence in Midi format
	 */
	public int[] getMidiSequence() {
		return fMidiSequence;
	}
}
