package com.ibm.microedition.media.typechecker;

/*
 *
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.IOException;
import java.util.Hashtable;
import com.ibm.microedition.media.MediaDescriptor;

/**
 * If everything else fails, make a decision based on the extension of the filename.
 * This class should be registered last in the chain.
 */
public class DefaultTypeChecker extends AbstractTypeChecker {

 	private final static Hashtable table = new Hashtable();

	public String check(MediaDescriptor md) throws IOException {

		table.put("mp3",MIME_TYPE_MP3);
		table.put("3gp",MIME_TYPE_3GP);
		table.put("m4v",MIME_TYPE_M4V);
		table.put("mp4",MIME_TYPE_MP4);
		table.put("mpg",MIME_TYPE_MPEG);
		table.put("mpeg",MIME_TYPE_MPEG);
		table.put("jts",MIME_TYPE_TONE);

		String protocol = md.getProtocol();

		if (protocol.equals(PROTOCOL_FILE)) {
			String extension = md.getFileExtension().toLowerCase();
			return (String) table.get(extension);
		} else if (protocol.equals(PROTOCOL_HTTP) || protocol.equals(PROTOCOL_HTTPS)) {
			return md.getHttpContentType();
		}
		return null;
	}
}
