package com.ibm.microedition.media.typechecker;

/*
 *
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.*;
import com.ibm.microedition.media.MediaDescriptor;

public class WavContentTypeChecker extends AbstractTypeChecker {

	public String check(MediaDescriptor md) throws IOException {
		String protocol = md.getProtocol();
		if (protocol == null) return null;

		if (protocol.equals(PROTOCOL_FILE)) {
			byte[] header = new byte[12];
			byte[] mediaDescriptorHeader = md.getHeader();
			int headerLength = 0;
			if (mediaDescriptorHeader != null) {
				headerLength = mediaDescriptorHeader.length;
				if (headerLength > 12 ) {
					header = new byte[mediaDescriptorHeader.length];
				}
				System.arraycopy(mediaDescriptorHeader, 0, header, 0, headerLength);
			}

			if (headerLength < 12) {
				InputStream is = md.getMediaIS();
				do {
					int partialRead=is.read(header,headerLength, 12 - headerLength);
					if (partialRead < 0) break;

					headerLength += partialRead;
				} while (headerLength < 12);
			}

			md.setHeader(header);
			if (header[0]  == 'R' &&
				header[1]  == 'I' &&
				header[2]  == 'F' &&
				header[3]  == 'F' &&
				header[8]  == 'W' &&
				header[9]  == 'A' &&
				header[10] == 'V' &&
				header[11] == 'E')
				{
					return MIME_TYPE_WAVE;
				}
		} else if (protocol.equals(PROTOCOL_HTTP) || protocol.equals(PROTOCOL_HTTPS)) {
			 String contentType = md.getHttpContentType();
			 if (contentType != null && contentType.equals(MIME_TYPE_WAVE)) return MIME_TYPE_WAVE;
		}
		return null;
	}
}
