package com.ibm.oti.connection;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2004  All Rights Reserved
 */

public abstract class ConnectionUtil {

public static final int NEGATIVE = 1;
public static final int NEGATIVE_OR_ZERO = 2;

public static final String[][] NO_PARAMETERS = new String[0][0];

public static String[][] getParameters(String params) {
	int index, lastIndex = 0, count=0;
	while (lastIndex < params.length()) {
		index = params.indexOf(';', lastIndex);
		if (index == -1) index = params.length();
		if (index > lastIndex) count++;
		lastIndex = index + 1;
	}
	String[][] equates = new String[count][2];
	count = 0;
	lastIndex = 0;
	while (lastIndex < params.length()) {
		index = params.indexOf(';', lastIndex);
		if (index == -1) index = params.length();
		String equate = params.substring(lastIndex, index);
		if (index > lastIndex) {
			int eq = equate.indexOf('=');
			if (eq != -1) {
				equates[count][0] = equate.substring(0, eq);
				equates[count][1] = equate.substring(eq+1, equate.length());
			} else equates[count][0] = equate;
			count++;
		}
		lastIndex = index + 1;
	}
	return equates;
}

public static boolean intParam(String key, String[] pair, int check, int[] result) {
	if (key.equals(pair[0]) && pair[1] != null) {
		try {
			int value = Integer.parseInt(pair[1]);
			if (check == NEGATIVE && value < 0)
				// K009d = {0} is negative
				throw new IllegalArgumentException(com.ibm.oti.util.Msg.getString("K009d", key));
			if (check == NEGATIVE_OR_ZERO && value <= 0)
				// K009e = {0} is negative or zero
				throw new IllegalArgumentException(com.ibm.oti.util.Msg.getString("K009e", key));
			result[0] = value;
		} catch (NumberFormatException e) {
			// K009f = invalid {0}: {1}
			throw new IllegalArgumentException(com.ibm.oti.util.Msg.getString("K009f", key, pair[1]));
		}
		return true;
	}
	return false;
}

}
