package com.ibm.oti.crypto;
/**
 * <p>
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2006  All Rights Reserved
 * </p>
 */
import java.io.IOException;

import com.ibm.j9.bluez.crypto.CL3;

public abstract class CL3BasedKey extends Key {
	CL3 workingKey;

	CL3BasedKey(Provider provider, byte[] key) throws IOException {
		super(provider, key);
		if (key.length != getMinimumKeyLength()) {
			// K01f9 = incorrect key length
			throw new IOException(com.ibm.oti.util.Msg.getString("K01f9")); //$NON-NLS-1$
		}
	}

	public abstract int getMinimumKeyLength();
}
