package com.ibm.oti.crypto;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

import java.io.IOException;

public class NullProvider extends Provider {

	public NullProvider() throws IOException {
		super(Provider.ALG_NULL, 0);
	}

	void destroyKey(Key key) {
		// No action required
	}

	void cryptInit(Key key, int operation, int padtype, byte[] iv) throws IOException {
		// No action required
	}

	byte[] cryptUpdate(Key key, byte[] bytes, int offset, int length, boolean finished) throws IOException {
		byte[] result = new byte[length];
		System.arraycopy(bytes, offset, result, 0, length);
		return result;
	}
}
