package com.ibm.oti.midlet.help;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2004  All Rights Reserved
 */

public class MidletSuiteId {
	private String midletSuiteName, suiteVendorName;

	public MidletSuiteId(String suiteName, String vendorName) {
		if (suiteName == null || vendorName == null)
			throw new NullPointerException();
		midletSuiteName = suiteName;
		suiteVendorName = vendorName;
	}

	public boolean equals(MidletSuiteId midletSuiteId) {
		return getSuiteName().equals(midletSuiteId.getSuiteName()) &&
			getVendorName().equals(midletSuiteId.getVendorName());
	}

	public String getSuiteName() {
		return midletSuiteName;
	}

	public String getVendorName() {
		return suiteVendorName;
	}

	public String getId() {
		return getVendorName() + "-" + getSuiteName();
	}
}
