
package com.ibm.oti.security.provider;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2005  All Rights Reserved
 */

/**
 * This class represents a X.509 public key that uses an algorithm that is not
 * recognized by any Provider, so the key bits are not parsed.
 *
 * @author		OTI
 * @version		initial
 */
public class UnparsedX509PublicKey
{

	private byte[] encodedKeySpec;	// Encoded key spec from the certificate
	String algorithm;

public UnparsedX509PublicKey(byte[] bytes) {
	this.encodedKeySpec = bytes;
}

/**
 * Answers the name of the algorithm that this key
 * will work with. If the algorithm is unknown, it
 * answers null.
 *
 * @return		String
 *					the receiver's algorithm
 */
public String getAlgorithm() {
	return algorithm;
};

/**
 * Answers the encoded form of the receiver.
 *
 * @return		byte[]
 *					the encoded form of the receiver
 */
public byte[] getEncoded(){
	byte[] copy = new byte[encodedKeySpec.length];
	System.arraycopy(encodedKeySpec, 0, copy, 0, encodedKeySpec.length);
	return copy;
};

/**
 * Answers the name of the format used to encode
 * the key, or null if it can not be encoded.
 *
 * @return		String
 *					the receiver's encoding format
 */
public String getFormat(){
	return "X.509";
}

/**
 * @param algorithm The algorithm to set.
 */
public void setAlgorithm(String algorithm) {
	this.algorithm = algorithm;
}

}
