package com.ibm.oti.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003  All Rights Reserved
 */

final public class NetworkActivityHook implements NetworkActivityListener {

	static private NetworkActivityListener listener = new NetworkActivityHook();

	private NetworkActivityHook() {}

	static public void setListener(NetworkActivityListener _listener) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap())
			throw new SecurityException();
		listener = _listener;
	}

	static public NetworkActivityListener getListener() {
		return listener;
	}

	/**
	 * @see com.ibm.oti.util.NetworkActivityListener#networkActivityStarted(String)
	 */
	public void networkActivityStarted(String operation) {}

	/**
	 * @see com.ibm.oti.util.NetworkActivityListener#networkActivityComplete(String)
	 */
	public void networkActivityComplete(String operation) {}
}
