
package com.ibm.oti.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2005  All Rights Reserved
 */

/**
 * This class implements a Stream whose position can be querried for.
 *
 * @author		OTI
 * @version		initial
 */
public class PositionedInputStream
	extends java.io.InputStream {

	int currentPosition = 0;	// Current position on the underlying stream

	private java.io.InputStream in;

/**
 * Constructs a new instance of the receiver.
 *
 * @param in java.io.InputStream The actual input stream where to read the bytes from.
 */
public PositionedInputStream(java.io.InputStream in) {
	this.in = in;
}

/**
 *  Return the current position in the receiver
 *
 * @return int	The current position in the receiver
 */
public int currentPosition() {
	return currentPosition;
}

/**
 * Reads the next byte of data from this input stream. The value
 * byte is returned as an <code>int</code> in the range
 * <code>0</code> to <code>255</code>. If no byte is available
 * because the end of the stream has been reached, the value
 * <code>-1</code> is returned. This method blocks until input data
 * is available, the end of the stream is detected, or an exception
 * is thrown.
 * <p>
 * The <code>read</code> method of <code>FilterInputStream</code>
 * calls the <code>read</code> method of its underlying input stream
 * and returns whatever value that method returns.
 *
 * @return     the next byte of data, or <code>-1</code> if the end of the
 *             stream is reached.
 * @exception  java.io.IOException  if an I/O error occurs.
 * @since      JDK1.0
 */
public int read() throws java.io.IOException {
	int read = in.read();
	if (read >= 0) currentPosition++;
	return read;

}

/**
 * Reads up to <code>len</code> bytes of data from this input stream
 * into an array of bytes. This method blocks until some input is
 * available.
 * <p>
 * The <code>read</code> method of <code>FilterInputStream</code>
 * calls the <code>read</code> method of its underlying input stream
 * with the same arguments and returns whatever value that method returns.
 *
 * @param      b     the buffer into which the data is read.
 * @param      off   the start offset of the data.
 * @param      len   the maximum number of bytes read.
 * @return     the total number of bytes read into the buffer, or
 *             <code>-1</code> if there is no more data because the end of
 *             the stream has been reached.
 *
 * @exception  java.io.IOException  if an I/O error occurs.
 *
 * @since      JDK1.0
 */
public int read(byte b[], int off, int len) throws java.io.IOException {
	int read = in.read(b,off,len);
	if (read >= 0) currentPosition += read;
	return read;
}

/**
 * Makes the current position on the underlying stream be assigned relative position zero.
 */
public void resetCurrentPosition() {
	currentPosition = 0;
}

/**
 * Skips over and discards <code>n</code> bytes of data from the
 * input stream. The <code>skip</code> method may, for a variety of
 * reasons, end up skipping over some smaller number of bytes,
 * possibly <code>0</code>. The actual number of bytes skipped is
 * returned.
 * <p>
 * The <code>skip </code>method of <code>FilterInputStream</code>
 * calls the <code>skip</code> method of its underlying input stream
 * with the same argument, and returns whatever value that method does.
 *
 * @param      n   the number of bytes to be skipped.
 * @return     the actual number of bytes skipped.
 * @exception  java.io.IOException  if an I/O error occurs.
 * @since      JDK1.0
 */
public long skip(long n) throws java.io.IOException {
	long skip = in.skip(n);
	currentPosition += skip;	// Maybe currentPosition should be long ?
	return skip;

}

}
