package com.ibm.oti.vm;

import java.io.*;
import java.util.*;
import com.ibm.oti.util.*;

/**
 * <p>This class is a model of a loaded jxe.
 *
 * <pre>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corp. 1999, 2006  All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * </pre>
 */
public final class Jxe {

	private long		jxePointer;
	private Hashtable       resTable;

	static final int DEFLATED = 8;
	static final int STORED = 0;

/**
 * Construct a new Jxe with a specified pointer.
 */
Jxe(long pointer) {
	this.jxePointer = pointer;
}

/**
 * Answer the pointer to this jxe.
 */
long getJxePointer() {
	return jxePointer;
}

/**
 * Return a resource as an InputStream.
 */
public InputStream getResourceAsStream(String name) {

	initializeResTable();

	JxeResource entry;
	while (true) {
		entry = (JxeResource)resTable.get(name);
		if (null != entry) {
			InputStream stream = new MemInputStream(entry.getPointer(), entry.getSize(), this);
			if (entry.getMethod() != STORED)
				// K01d0 = Compressed resources in JXE not supported
				throw new RuntimeException(com.ibm.oti.util.Msg.getString("K01d0"));
			return stream;
		}

		if (!name.startsWith("/", 0)) return null;
		name = name.substring(1);
	}
}

/**
 * Initialize the resource table.
 */
private void initializeResTable() {
	JxeResourceTable resources;

	if (null != resTable) return;

	long pointer;
	try {
		resources = new JxeResourceTable(new MemInputStream(getJxePointer(), Integer.MAX_VALUE, null));
	} catch (IOException e) {
		resTable = new Hashtable(0);
		return;
	}

	resTable = resources.getTable();
}

}
