package java.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2004  All Rights Reserved
 */

/**
 * OutputStream is an abstract class for all byte output streams.  It provides basic
 * method implementations for writing bytes to a stream.
 *
 * @author		OTI
 * @version		initial
 *
 * @see			InputStream
 */

public abstract class OutputStream {
/**
 * This constructor does nothing interesting.  Provided for signature compatibility.
 *
 * @author		OTI
 * @version		initial
 *
 */

public OutputStream() {
}
/**
 * Close this OutputStream.  Concrete implementations of this class should
 * free any resources during close.  This implementation does nothing.
 *
 * @author		OTI
 * @version		initial
 *
 * @throws 		IOException	If an error occurs attempting to close this OutputStream.
 */

public void close() throws IOException {}
/**
 * Flush this OutputStream.  Concrete implementations of this class should
 * ensure any pending writes to the underlying stream are written out when this
 * method is envoked. This implementation does nothing.
 *
 * @author		OTI
 * @version		initial
 *
 * @throws 		IOException	If an error occurs attempting to flush this OutputStream.
 */

public void flush() throws IOException {}
/**
 * Writes the entire contents of the byte array <code>buffer</code>
 * to this OutputStream.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		buffer		the buffer to be written
 *
 * @throws 		IOException	If an error occurs attempting to write to this OutputStream.
 */

public void write(byte buffer[]) throws IOException {
	write(buffer, 0, buffer.length);
}
/**
 * Writes <code>count</code> <code>bytes</code> from the byte array
 * <code>buffer</code> starting at <code>offset</code> to this
 * OutputStream.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		buffer		the buffer to be written
 * @param		offset		offset in buffer to get bytes
 * @param		count		number of bytes in buffer to write
 *
 * @throws 		IOException					If an error occurs attempting to write to this OutputStream.
 * @throws		IndexOutOfBoundsException	If offset or count are outside of bounds.
 */

public void write(byte buffer[], int offset, int count) throws IOException {
	// avoid int overflow, check null buffer
	if (offset <= buffer.length && 0 <= offset && 0 <= count && count <= buffer.length - offset) {
		for (int i = offset; i < offset + count; i++)
			write(buffer[i]);
	// K002f = Arguments out of bounds
	} else throw new ArrayIndexOutOfBoundsException(com.ibm.oti.util.Msg.getString("K002f"));
}
/**
 * Writes the specified byte <code>oneByte</code> to this OutputStream.  Only
 * the low order byte of <code>oneByte</code> is written.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		oneByte		the byte to be written
 *
 * @throws 		IOException	If an error occurs attempting to write to this OutputStream.
 */

public abstract void write(int oneByte)  throws IOException;
}
