
package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

/**
 * This class is the superclass of all classes which
 * represent recoverable exceptions. When Exceptions
 * are thrown, they may be caught by application code.
 *
 * @author		OTI
 * @version		initial
 *
 * @see		Throwable
 * @see		Error
 * @see		RuntimeException
 */
public class Exception extends Throwable {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public Exception() {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public Exception (String detailMessage) {
	super(detailMessage);
}

}
