
package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2002  All Rights Reserved
 */

/**
 * This runtime exception is thrown when a program
 * attempts to access a value in an indexable collection
 * using a value which is outside the possible range
 * of indices.
 *
 * @author		OTI
 * @version		initial
 */
public class IndexOutOfBoundsException extends RuntimeException {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public IndexOutOfBoundsException () {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public IndexOutOfBoundsException (String detailMessage) {
	super(detailMessage);
}

}
