
package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2002  All Rights Reserved
 */

/**
 * This class is the superclass of all classes which
 * represent errors that occur during the operation
 * of the virtual machine.
 *
 * @author		OTI
 * @version		initial
 *
 * @see		Error
 */
public abstract class VirtualMachineError extends Error {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public VirtualMachineError() {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public VirtualMachineError (String detailMessage) {
	super(detailMessage);
}

}
