package java.lang.ref;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2005  All Rights Reserved
 */

/**
 * Abstract class which describes behavior common to all reference objects.
 *
 * @author		OTI
 * @version		initial
 * @since		JDK1.2
 */
public abstract class Reference extends Object {
	private Object referent;

	private Object queue; // Required to maintain shape for VM
	private boolean enqueued;

/**
 * Make the referent null.  This does not force the reference object to be enqueued.
 *
 * @author		OTI
 * @version		initial
 */
public void clear () {
	referent = null;
}

/**
 * Return the referent of the reference object.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		Object
 *					Referent to which reference refers,
 *					or null if object has been cleared.
 */
public Object get() {
	return referent;
}

/**
 * Constructs a new instance of this class.
 *
 * @author		OTI
 * @version		initial
 */
Reference() {
}

/**
 * Initialize a newly created reference object. Associate the
 * reference object with the referent.
 *
 * @param r the referent
 */
void initReference (Object r) {
	initReferenceImpl(r);
}

/**
 * Associate the reference object with the referent.
 *
 * @author		OTI
 * @version		initial
 */
private final native void initReferenceImpl(Object r);

}

