package java.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

/**
 * Date represents a specific moment in time, to the millisecond.
 *
 * @author		OTI
 * @version		initial
 *
 * @see			System#currentTimeMillis
 */

public class Date {
	transient private long milliseconds;

private static String toString(GregorianCalendar cal) {
	StringBuffer buffer = new StringBuffer(25);
	int offset = (cal.get(Calendar.DAY_OF_WEEK) - 1) * 3;
	buffer.append("SunMonTueWedThuFriSat".substring(offset, offset + 3));
	buffer.append(' ');
	offset = cal.get(Calendar.MONTH) * 3;
	buffer.append("JanFebMarAprMayJunJulAugSepOctNovDec".substring(offset, offset + 3));
	buffer.append(' ');
	format(buffer, cal.get(Calendar.DATE), 2);
	buffer.append(' ');
	format(buffer, cal.get(Calendar.HOUR_OF_DAY), 2);
	buffer.append(':');
	format(buffer, cal.get(Calendar.MINUTE), 2);
	buffer.append(':');
	format(buffer, cal.get(Calendar.SECOND), 2);
	buffer.append(' ');
	String tz = cal.getTimeZone().getID();
	if (tz != null) {
		buffer.append(tz);
		buffer.append(' ');
	}
	format(buffer, cal.get(Calendar.YEAR), 4);
	return buffer.toString();
}

private static void format(StringBuffer buffer, int value, int digits) {
	String out = String.valueOf(value);
	for (int i=0; i<digits - out.length(); i++)
		buffer.append('0');
	buffer.append(out);
}

/**
 * Initializes this Date instance to the current date and time.
 *
 * @author		OTI
 * @version		initial
 */
public Date () {
	this (System.currentTimeMillis ());
}

/**
 * Initializes this Date instance using the specified millisecond value. The
 * value is the number of milliseconds since Jan. 1, 1970 GMT.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		milliseconds	the number of milliseconds since Jan. 1, 1970 GMT
 */
public Date (long milliseconds) {
	this.setTime (milliseconds);
}

/**
 * Compares the specified object to this Date and answer if they
 * are equal. The object must be an instance of Date and have the
 * same millisecond value.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		object	the object to compare with this object
 * @return		true if the specified object is equal to this Date, false otherwise
 *
 * @see			#hashCode
 */
public boolean equals (Object object) {
	return (object == this) || (object instanceof Date) &&
		(milliseconds == ((Date) object).milliseconds);
}

/**
 * Answers this Date as a millisecond value. The value is the number of
 * milliseconds since Jan. 1, 1970 GMT.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the number of milliseconds since Jan. 1, 1970 GMT.
 */
public long getTime () {
	return milliseconds;
}

/**
 * Answers an integer hash code for the receiver. Objects which are
 * equal answer the same value for this method.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the receiver's hash
 *
 * @see			#equals
 */
public int hashCode() {
	return (int)(milliseconds >>> 32) ^ (int) milliseconds;
}

/**
 * Sets this Date to the specified millisecond value. The value is the number of
 * milliseconds since Jan. 1, 1970 GMT.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		milliseconds	the number of milliseconds since Jan. 1, 1970 GMT.
 */
public void setTime (long milliseconds) {
	this.milliseconds = milliseconds;
}

/**
 * Answers the string representation of this Date in the
 * format: Tue Jun 22 13:07:00 GMT 1999
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the string representation of this Date
 */
public String toString () {
	GregorianCalendar cal = new GregorianCalendar(milliseconds);
	return toString(cal);
}

}
