package java.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2002  All Rights Reserved
 */

/**
 * An Enumeration is used to sequence over a collection of objects.
 *
 * @author		OTI
 * @version		initial
 *
 * @see			Hashtable
 * @see			Properties
 * @see			Vector
 */
public interface Enumeration {
/**
 * Answers if this Enumeration has more elements.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		true if there are more elements, false otherwise
 *
 * @see			#nextElement
 */
public boolean hasMoreElements ();
/**
 * Answers the next element in this Enumeration.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the next element in this Enumeration
 *
 * @exception	NoSuchElementException when there are no more elements
 *
 * @see			#hasMoreElements
 */
public Object nextElement ();
}
