package java.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

/**
 * <code>Stack</code> is a Last-In/First-Out(LIFO) data structure which represents
 * a stack of objects.
 * It enables users to pop and push onto the stack, including null objects.
 * There is no limit to the size of the stack
 *
 *
 * @author		OTI
 * @version		initial
 *
 */

public class Stack extends Vector {
/**
 * Constructs a stack with the default size of <code>Vector</code>.
 *
 * @author		OTI
 * @version		initial
 */
public Stack() {
	super();
}
/**
 * Determines if the stack is empty or not.
 *
 * @author		OTI
 * @version		initial
 *
 * @return 		true if the stack is empty, false otherwise
 */
public boolean empty() {
	return elementCount == 0;
}
/**
 * Returns the element at the top of the stack without removing it.
 *
 * @author		OTI
 * @version		initial
 *
 * @return 		the element at the top of the Stack
 * @exception	EmptyStackException when empty() is true
 * @see 		#pop
 */
public synchronized Object peek() {
	try {
		return elementData[elementCount - 1];
	} catch (IndexOutOfBoundsException e){
		throw new EmptyStackException();
	}
}
/**
 * Returns the element at the top of the stack and removes it.
 *
 * @author		OTI
 * @version		initial
 *
 * @return 		the element at the top of the stack.
 * @exception	EmptyStackException when empty() is true
 * @see 		#peek
 * @see 		#push
 */
public synchronized Object pop() {
	try {
		int index = elementCount - 1;
		Object obj = elementData[index];
		removeElementAt(index);
		return obj;
	} catch (IndexOutOfBoundsException e) {
		throw new EmptyStackException();
	}
}
/**
 * Pushes the object from the parameter onto the top of the stack.
 *
 * @author		OTI
 * @version		initial
 *
 * @param 	object 	The object to be added to the stack
 *
 * @return	the object argument
 *
 * @see 	#peek
 * @see 	#pop
 */
public synchronized Object push(Object object) {
	addElement(object);
	return object;
}
/**
 * Returns the index of the first occurence of the object.
 *
 * @author		OTI
 * @version		initial
 *
 * @return 		the index of the first occurence of the object
 * @param o		the object to be searched
 */
public synchronized int search(Object o) {
	int index = lastIndexOf(o);
	if (index >= 0) return (elementCount - index);
	return -1;
}
}
