package java.util;

/*
 * Licensed Materials - Property of IBM,
* (c) Copyright IBM Corp. 2006  All Rights Reserved
 */

final class TimeZones {

	private static final int ONE_HOUR = 3600000;

public static TimeZone[] getTimeZones() {
	return new TimeZone[] {

	// Pacific/Apia
	new SimpleTimeZone(-11 * ONE_HOUR, "MIT"),
	new SimpleTimeZone(-10 * ONE_HOUR, "HST"),
	// America/Anchorage
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-9 * ONE_HOUR, "AST",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-9 * ONE_HOUR, "AST",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2007, 0, 0, 0},
	}, new long[] {
			1167642000000L,	// 2007
	}),
	// America/Los_Angeles
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-8 * ONE_HOUR, "PST",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-8 * ONE_HOUR, "PST",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2007, 0, 0, 0},
	}, new long[] {
			1167638400000L,	// 2007
	}),
	// America/Denver
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-7 * ONE_HOUR, "MST",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-7 * ONE_HOUR, "MST",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2007, 0, 0, 0},
	}, new long[] {
			1167634800000L,	// 2007
	}),
	// America/Phoenix
	new SimpleTimeZone(-7 * ONE_HOUR, "PNT"),
	// America/Chicago
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-6 * ONE_HOUR, "CST",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-6 * ONE_HOUR, "CST",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2007, 0, 0, 0},
	}, new long[] {
			1167631200000L,	// 2007
	}),
	// America/New_York
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-5 * ONE_HOUR, "EST",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-5 * ONE_HOUR, "EST",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2007, 0, 0, 0},
	}, new long[] {
			1167627600000L,	// 2007
	}),
	// America/Indiana/Indianapolis
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-5 * ONE_HOUR, "IET"),
		new SimpleTimeZone(-5 * ONE_HOUR, "IET",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-5 * ONE_HOUR, "IET",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2006, 0, 0, 0},	// 2006
			{2007, 0, 0, 0},
	}, new long[] {
			1136091600000L,	// 2006
			1167627600000L,	// 2007
	}),
	// America/Caracas
	new SimpleTimeZone(-4 * ONE_HOUR, "PRT"),
	// America/St_Johns
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-3 * ONE_HOUR - 1800000, "CNT",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 60000, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 60000, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-3 * ONE_HOUR - 1800000, "CNT",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 60000, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 60000, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2007, 0, 0, 0},
	}, new long[] {
			1167622200000L,	// 2007
	}),
	// America/Argentina/Buenos_Aires
	new SimpleTimeZone(-3 * ONE_HOUR, "AGT"),
	// America/Sao_Paulo
	new SimpleTimeZone(-3 * ONE_HOUR, "BET",
		Calendar.OCTOBER, 15, -Calendar.SUNDAY, 0 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
		Calendar.FEBRUARY, 15, -Calendar.SUNDAY, 0 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
		ONE_HOUR),
	// Etc/UTC
	new SimpleTimeZone(0 * ONE_HOUR, "UTC"),
	new SimpleTimeZone(0 * ONE_HOUR, "WET",
		Calendar.MARCH, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		ONE_HOUR),
	new SimpleTimeZone(1 * ONE_HOUR, "CET",
		Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		ONE_HOUR),
	// Europe/Paris
	new SimpleTimeZone(1 * ONE_HOUR, "ECT",
		Calendar.MARCH, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		ONE_HOUR),
	new SimpleTimeZone(1 * ONE_HOUR, "MET",
		Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		ONE_HOUR),
	// Africa/Cairo
	new SimpleTimeZone(2 * ONE_HOUR, "ART",
		Calendar.APRIL, -1, Calendar.FRIDAY, 0 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		Calendar.SEPTEMBER, -1, Calendar.THURSDAY, 23 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		ONE_HOUR),
	// Africa/Johannesburg
	new SimpleTimeZone(2 * ONE_HOUR, "CAT"),
	new SimpleTimeZone(2 * ONE_HOUR, "EET",
		Calendar.MARCH, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		ONE_HOUR),
	// Asia/Riyadh
	new SimpleTimeZone(3 * ONE_HOUR, "EAT"),
	// Asia/Yerevan
	new SimpleTimeZone(4 * ONE_HOUR, "NET",
		Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		ONE_HOUR),
	// Asia/Karachi
	new SimpleTimeZone(5 * ONE_HOUR, "PLT"),
	// Asia/Calcutta
	new SimpleTimeZone(5 * ONE_HOUR + 1800000, "IST"),
	// Asia/Dhaka
	new SimpleTimeZone(6 * ONE_HOUR, "BST"),
	// Asia/Bangkok
	new SimpleTimeZone(7 * ONE_HOUR, "VST"),
	// Asia/Shanghai
	new SimpleTimeZone(8 * ONE_HOUR, "CTT"),
	// Asia/Shanghai
	new SimpleTimeZone(8 * ONE_HOUR, "PRC"),
	// Asia/Tokyo
	new SimpleTimeZone(9 * ONE_HOUR, "JST"),
	// Asia/Seoul
	new SimpleTimeZone(9 * ONE_HOUR, "ROK"),
	// Australia/Darwin
	new SimpleTimeZone(9 * ONE_HOUR + 1800000, "ACT"),
	// Australia/Sydney
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(10 * ONE_HOUR, "AET",
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
		new SimpleTimeZone(10 * ONE_HOUR, "AET",
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
		new SimpleTimeZone(10 * ONE_HOUR, "AET",
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2006, 0, 0, 0},
			{2007, 0, 0, 0},
	}, new long[] {
			1136034000000L,	// 2006
			1167570000000L,	// 2007
	}),
	// Pacific/Guadalcanal
	new SimpleTimeZone(11 * ONE_HOUR, "SST"),
	// Pacific/Auckland
	new SimpleTimeZone(12 * ONE_HOUR, "NST",
		Calendar.OCTOBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		Calendar.MARCH, 15, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		ONE_HOUR),
	new SimpleTimeZone(-6 * ONE_HOUR, "America/Costa_Rica"),
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(-4 * ONE_HOUR, "America/Halifax",
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(-4 * ONE_HOUR, "America/Halifax",
			Calendar.MARCH, 8, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.NOVEMBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2007, 0, 0, 0},
	}, new long[] {
			1167624000000L,	// 2007
	}),
	new SimpleTimeZone(-2 * ONE_HOUR, "Atlantic/South_Georgia"),
	new SimpleTimeZone(0 * ONE_HOUR, "Europe/London",
		Calendar.MARCH, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		ONE_HOUR),
	new SimpleTimeZone(1 * ONE_HOUR, "Africa/Algiers"),
	new SimpleTimeZone(2 * ONE_HOUR, "Africa/Cairo",
		Calendar.APRIL, -1, Calendar.FRIDAY, 0 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		Calendar.SEPTEMBER, -1, Calendar.THURSDAY, 23 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		ONE_HOUR),
	new SimpleTimeZone(2 * ONE_HOUR, "Africa/Harare"),
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.APRIL, 1, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 9, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 1, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 16, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 5, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 27, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 12, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.APRIL, 1, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 2, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 23, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 8, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 28, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 20, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.APRIL, 1, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 9, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 24, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 16, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 6, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 27, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 12, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.APRIL, 1, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 2, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 24, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 6, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 28, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 20, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 10, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 24, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 16, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 6, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 21, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 12, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.APRIL, 1, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 2, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 17, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.OCTOBER, 7, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 28, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem",
			Calendar.MARCH, 26, -Calendar.FRIDAY, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 13, 0, 2 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(2 * ONE_HOUR, "Asia/Jerusalem"),
	}, new int[][] {
			{2006, 0, 0, 0},
			{2007, 0, 0, 0},
			{2008, 0, 0, 0},
			{2009, 0, 0, 0},
			{2010, 0, 0, 0},
			{2011, 0, 0, 0},
			{2012, 0, 0, 0},
			{2013, 0, 0, 0},
			{2014, 0, 0, 0},
			{2015, 0, 0, 0},
			{2016, 0, 0, 0},
			{2017, 0, 0, 0},
			{2018, 0, 0, 0},
			{2019, 0, 0, 0},
			{2020, 0, 0, 0},
			{2021, 0, 0, 0},
			{2022, 0, 0, 0},
			{2023, 0, 0, 0},
			{2024, 0, 0, 0},
			{2025, 0, 0, 0},
			{2026, 0, 0, 0},
			{2027, 0, 0, 0},
			{2028, 0, 0, 0},
			{2029, 0, 0, 0},
			{2030, 0, 0, 0},
			{2031, 0, 0, 0},
			{2032, 0, 0, 0},
			{2033, 0, 0, 0},
			{2034, 0, 0, 0},
			{2035, 0, 0, 0},
			{2036, 0, 0, 0},
			{2037, 0, 0, 0},
			{2038, 0, 0, 0},
	}, new long[] {
			1136066400000L,	// 2006
			1167602400000L,	// 2007
			1199138400000L,	// 2008
			1230760800000L,	// 2009
			1262296800000L,	// 2010
			1293832800000L,	// 2011
			1325368800000L,	// 2012
			1356991200000L,	// 2013
			1388527200000L,	// 2014
			1420063200000L,	// 2015
			1451599200000L,	// 2016
			1483221600000L,	// 2017
			1514757600000L,	// 2018
			1546293600000L,	// 2019
			1577829600000L,	// 2020
			1609452000000L,	// 2021
			1640988000000L,	// 2022
			1672524000000L,	// 2023
			1704060000000L,	// 2024
			1735682400000L,	// 2025
			1767218400000L,	// 2026
			1798754400000L,	// 2027
			1830290400000L,	// 2028
			1861912800000L,	// 2029
			1893448800000L,	// 2030
			1924984800000L,	// 2031
			1956520800000L,	// 2032
			1988143200000L,	// 2033
			2019679200000L,	// 2034
			2051215200000L,	// 2035
			2082751200000L,	// 2036
			2114373600000L,	// 2037
			2145909600000L,	// 2038
	}),
	new SimpleTimeZone(2 * ONE_HOUR, "Europe/Bucharest",
		Calendar.MARCH, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, ONE_HOUR, SimpleTimeZone.UTC_TIME,
		ONE_HOUR),
	new SimpleTimeZone(3 * ONE_HOUR, "Europe/Moscow",
		Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
		ONE_HOUR),
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(3 * ONE_HOUR + 1800000, "Asia/Tehran",
			Calendar.MARCH, 22, 0, 0 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			Calendar.SEPTEMBER, 22, 0, 0 * ONE_HOUR, SimpleTimeZone.WALL_TIME,
			ONE_HOUR),
		new SimpleTimeZone(3 * ONE_HOUR + 1800000, "Asia/Tehran"),
	}, new int[][] {
			{2006, 0, 0, 0},
	}, new long[] {
			1136061000000L,	// 2006
	}),
	new SimpleTimeZone(4 * ONE_HOUR + 1800000, "Asia/Kabul"),
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(9 * ONE_HOUR + 1800000, "Australia/Adelaide",
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
		new SimpleTimeZone(9 * ONE_HOUR + 1800000, "Australia/Adelaide",
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
		new SimpleTimeZone(9 * ONE_HOUR + 1800000, "Australia/Adelaide",
			Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2006, 0, 0, 0},
			{2007, 0, 0, 0},
	}, new long[] {
			1136035800000L,	// 2006
			1167571800000L,	// 2007
	}),
	new SimpleTimeZone(10 * ONE_HOUR, "Australia/Brisbane"),
	new TimeZoneTable(new SimpleTimeZone[] {
		new SimpleTimeZone(10 * ONE_HOUR, "Australia/Hobart",
			Calendar.OCTOBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
		new SimpleTimeZone(10 * ONE_HOUR, "Australia/Hobart",
			Calendar.OCTOBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.APRIL, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
		new SimpleTimeZone(10 * ONE_HOUR, "Australia/Hobart",
			Calendar.OCTOBER, 1, -Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			Calendar.MARCH, -1, Calendar.SUNDAY, 2 * ONE_HOUR, SimpleTimeZone.STANDARD_TIME,
			ONE_HOUR),
	}, new int[][] {
			{2006, 0, 0, 0},
			{2007, 0, 0, 0},
	}, new long[] {
			1136034000000L,	// 2006
			1167570000000L,	// 2007
	}),

	};
}
}
