package javax.microedition.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

/**
 * This interface represents a comm connection, which allows the
 * user to get and set the baud rate for the connection.
 *
 * @author OTI
 * @version initial
 * @since MIDP 2.0
 *
 */
public interface CommConnection extends StreamConnection {

	/**
	 * Changes the baudrate of the connection to the supplied value,
	 * and returns the old baudrate
	 * @param rate	the baud rate of the connection
	 * @return int	the old baud rate
	 */
	public int setBaudRate(int rate);

	/**
	 * Answers the baud rate of ths comm connection
	 * @return int	the baudrate of the connection
	 */
	public int getBaudRate();
}
