package javax.microedition.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2004  All Rights Reserved
 */

/**
 * The class PushRegistry is used to maintain the collection of inbound connections.
 *
 * @author		OTI
 * @version		initial
 */
public class PushRegistry {

	private PushRegistry() {
	}

	/**
	 * Used to register a connection with the AMS (Application Management Software).
	 *
	 * @param 		connection 	the generic protocol for the connection
	 * @param 		midlet 		the class name of the MIDlet to be registered
	 * @param 		filter 		a URL that describes the senders allowed to launch the MIDlet
	 *
	 * @throws 		IllegalArgumentException 		if either connection or filter string are invalid
	 * @throws 		ConnectionNotFoundException 	if the requested protocol is not supported for push on this platform
	 * @throws 		java.io.IOException 			if a generic problem occurs or the connection has already been registered
	 * @throws 		ClassNotFoundException 			if the MIDlet cannot be found in the context
	 * @throws 		SecurityException 				if the MIDlet does not have permission
	 */
	public static void registerConnection(String connection, String midlet, String filter)
		throws ClassNotFoundException, java.io.IOException
	{
		// K0224 = PushRegistry not supported
		throw new ConnectionNotFoundException(com.ibm.oti.util.Msg.getString("K0224"));
	}

	/**
	 * Used to remove an already registered connection.
	 *
	 * @param 		connection 		the generic protocol for the connection to remove
	 * @return		<code>false</code> if it did not succeed or the connection did not exist, <code>true</code> if successful
	 *
	 * @throws 		SecurityException if the MIDlet is not allowed to perform this operation
	 */
	public static boolean unregisterConnection(String connection) {
		return false;
	}

	/**
	 * Used to retrieve the list of registered connections for this MIDlet suite.
	 *
	 * @param 		available 		if false, return the list of registered connections, if true return only those with input available
	 * @return 		an array of connections Strings
	 */
	public static String[] listConnections(boolean available) {
		return new String[0];
	}

	/**
	 * Returns the MIDlet.
	 *
	 * @param 		connection
	 * @return		null
	 */
	public static String getMIDlet(String connection) {
		return null;
	}

	/**
	 * @param 		connection
	 * @return		null
	 */
	public static String getFilter(String connection) {
		return null;
	}

	/**
	 * @param 		midlet
	 * @param 		time
	 * @return		null
	 *
	 * @throws 		ClassNotFoundException			if the class is not found
	 * @throws 		ConnectionNotFoundException		since alarms are not supported
	 */
	public static long registerAlarm(String midlet, long time)
		throws ClassNotFoundException, ConnectionNotFoundException
	{
		// K0225 = Alarms not supported
		throw new ConnectionNotFoundException(com.ibm.oti.util.Msg.getString("K0225"));
	}
}
