package javax.microedition.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

/**
 * The interface for secure socket connections, allowing socket settings to be
 * read/modified and allowing the local and remote addresses and ports to be retrieved.
 *
 * @author OTI
 * @since MIDP 2.0
 * @version initial
 *
 */
public interface SecureConnection extends SocketConnection {

/**
 * Answers the security information associated with this connection.
 *
 * @return the security information for this connection
 * @throws java.io.IOException if a connection failure occurs
 */
public SecurityInfo getSecurityInfo() throws java.io.IOException;

}
