package javax.microedition.io;

import javax.microedition.pki.Certificate;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2004  All Rights Reserved
 */

/**
 * The interface provides information about a secure connection.
 *
 * @author OTI
 * @since MIDP 2.0
 * @version initial
 *
 */
public interface SecurityInfo {

/**
 * Answers the name of the cipher suite for this connection.
 *
 * @return the name of the cipher suite
 */
public String getCipherSuite();

/**
 * Answers the name of the protocol for this connection.
 *
 * @return the name of the protocol
 */
public String getProtocolName();

/**
 * Answers the protocol version for this connection.
 *
 * @return the protocol version
 */
public String getProtocolVersion();

/**
 * Answers the certificate used to establish this secure connection with the server.
 *
 * @return the server certificate
 */
public Certificate getServerCertificate();

}
