package javax.microedition.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.IOException;

/**
 * An interface to represent serversocket connections. Allows the local address and port
 * of the connection to be retrieved.
 *
 * @author OTI
 * @since MIDP 2.0
 * @version initial
 */
public interface ServerSocketConnection extends StreamConnectionNotifier {

	/**
	 * Answers the local address for the connection.
	 *
	 * @return String	the local address
	 * @throws IOException	if the connection was already closed
	 *
	 */
	public String getLocalAddress() throws IOException;

	/**
	 * Answers the local port for the connection.
	 * @return int	the local port number
	 * @throws IOException	if the connection was already closed
	 *
	 */
	public int getLocalPort() throws IOException;

}
