package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class ButtonData {

	static final int IMAGE_WIDTH = Device.getIconWidth();
	static final int IMAGE_HEIGHT = Device.getIconHeight();
	static final int IMAGE_V_MARGIN = 2;

	static final int ARC = 8;
	static final int TOP_MARGIN = 2;
	static final int BOTTOM_MARGIN = 2;
	static final int RIGHT_MARGIN = 4;

	static final int TEXT_H_MARGIN = 3;
	static final int TEXT_TOP_MARGIN = 0;
	static final int TEXT_BOTTOM_MARGIN = 1;
	static final int TEXT_H_OFFSET = TEXT_H_MARGIN;
	static final int TEXT_V_OFFSET = TEXT_TOP_MARGIN;

	static final int TOTAL_H_MARGIN = 2 * TEXT_H_MARGIN;
	static final int TOTAL_TEXT_V_MARGIN = TEXT_TOP_MARGIN + TEXT_BOTTOM_MARGIN;
	static final int TOTAL_IMAGE_V_MARGIN = 2 * IMAGE_V_MARGIN;

	static final int DEFAULT_MIN_WIDTH = TOTAL_H_MARGIN	+ Component.gFont.getStringWidth("W..."); //$NON-NLS-1$
	static final int MIN_HEIGHT = Component.FONT_HEIGHT + TOP_MARGIN + BOTTOM_MARGIN;

	boolean fPressed, fHighlighted;

	int fX, fY, fWidth, fHeight;
	String fText;
	Command fCommand;

	boolean contains(int x, int y) {
		return (x >= fX) && (y >= fY) && ((x - fX) < fWidth) && ((y - fY) < fHeight);
	}
}
