package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

abstract class ButtonWidget extends Component {

	boolean fHighlighted, fPressed, fEnabled;
	String fText;

	IButtonListener fButtonListener;

	ButtonWidget(Composite parent) {
		super(parent);
		fEnabled = true; /* All buttons are enabled by default */
	}

	void setText(String string) {
		fText = stripNewlines(string);
	}

	void setEnabled(boolean state) {
		fEnabled = state;
		repaint();
	}

	void setListener(IButtonListener listener) {
		fButtonListener = listener;
	}

	void notifyListener() {
		final ButtonWidget button = this;
		Device.postRunnable(new Runnable() {
			public void run() {
				if (fButtonListener != null) {
					try {
						fButtonListener.buttonFired(button);
					} catch (Throwable e) {
						e.printStackTrace();
					}
				}
			}
		});
	}

	boolean pointerPressed(int x, int y) {
		if (!fEnabled) return false;
		fHighlighted = true;
		fPressed = true;
		repaint();
		return true;
	}

	boolean pointerReleased(int x, int y) {
		if (!fEnabled) return false;
		if (fPressed) {
			notifyListener();
			fPressed = false;
		}
		repaint();
		return true;
	}

	boolean pointerDragged(int x, int y) {
		if (!fEnabled) return false;
		boolean contains = contains(x, y);
		if (fPressed != contains) repaint();
		fPressed = contains;
		return true;
	}

	boolean keyPressed(int keyCode) {
		if (!fEnabled) return false;
		if (CanvasPeer.getGameAction(keyCode) == Canvas.FIRE) {
			fPressed = true;
			repaint();
			notifyListener();
			return true;
		}
		return false;
	}

	boolean keyReleased(int keyCode) {
		if (!fEnabled) return false;
		if (CanvasPeer.getGameAction(keyCode) == Canvas.FIRE) {
			fPressed = false;
			repaint();
			return true;
		}
		return false;
	}

	int getMinimumHeight() {
		return fHeight;
	}

	int getMinimumWidth() {
		return fWidth;
	}

	boolean traverse(int direction, int viewWidth, int viewHeight, int[] visibleRectangle, int x, int y) {
		boolean accept = false;

		if (!fEnabled) {
			if (visibleRectangle[2] < fWidth || visibleRectangle[3] < fHeight) {
				visibleRectangle[0] = 0;
				visibleRectangle[1] = 0;
				visibleRectangle[2] = fWidth;
				visibleRectangle[3] = fHeight;
				return true;
			}
			return false;
		}

		switch (direction) {
			case Canvas.UP:
			case Canvas.DOWN:
			case Canvas.LEFT:
			case Canvas.RIGHT:
				accept = !hasFocus();
				break;
			case CustomItem.NONE:
				accept = contains(x, y);
				break;
		}

		if (accept) fHighlighted = true;

		visibleRectangle[0] = 0;
		visibleRectangle[1] = 0;
		visibleRectangle[2] = fWidth;
		visibleRectangle[3] = fHeight;

		repaint();
		return accept;
	}

	void traverseOut() {
		fPressed = fHighlighted = false;
		super.traverseOut();
	}
}
