package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

class CanvasMediaAccessor implements IMediaCanvasAccessor {

	private Canvas fCanvas;
	private FastVector fListeners;
	private Graphics fGraphics;

	CanvasMediaAccessor(Canvas canvas) {
		super();
		if (canvas == null) throw new IllegalArgumentException();
		fCanvas = canvas;
		MediaAccessManager.addAccessor(canvas,this);
	}

	public Graphics getGraphics() {

		if (fCanvas.fPeer == null) return null;

		if (fGraphics != null) {
			/*
			 * Dispose the previous Graphics only when
			 * the caller needs a new one.  Even though
			 * fGraphics becomes invalid after hideMedia,
			 * it is not thread safe to dispose it there.
			 */
			fGraphics.dispose();
		}

		fGraphics = fCanvas.fPeer.getDisplayGraphics();

		return fGraphics;
	}

	public void flushGraphics(Graphics g) {
		g.flush();
	}

	public void flushGraphics(Graphics g, int x, int y, int w, int h) {
		g.flush(x, y, w, h);
	}

	public void addListener(IMediaContainerListener listener) {
		if (fListeners == null) fListeners = new FastVector();

		synchronized (fListeners) {
			if (!fListeners.contains(listener)) fListeners.addElement(listener);
		}
	}

	public void removeListener(IMediaContainerListener listener) {
		if (fListeners == null) return;

		synchronized (fListeners) {
			if (fListeners.contains(listener)) fListeners.removeElement(listener);
		}
	}

	/*
	 * It is less intrusive on the MIDP implementation to have the
	 * accessor manage the listeners.
	 */
	void showMedia(int x, int y, int width, int height) {
		if (fListeners != null) {
			synchronized (fListeners) {
				for (int i = 0; i < fListeners.size(); i++) {
					IMediaContainerListener listener = (IMediaContainerListener)fListeners.elementAt(i);
					listener.showMedia(x, y, width, height);
				}
			}
		}
	}

	void hideMedia() {
		if (fGraphics != null) fGraphics.dispose();
		if (fListeners != null) {
			synchronized (fListeners) {
				for (int i = 0; i < fListeners.size(); i++) {
					IMediaContainerListener listener = (IMediaContainerListener)fListeners.elementAt(i);
					listener.hideMedia();
				}
			}
		}
	}
}
