package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import java.util.*;

import com.ibm.ive.midp.*;

class ChoiceComponent extends Composite implements IChoicePeer, IButtonListener {

	static final int H_MARGIN = 2;
	static final int V_MARGIN = 2;

	static final int TOTAL_H_MARGIN = H_MARGIN * 2;
	static final int TOTAL_V_MARGIN = V_MARGIN * 2;
	static final int BORDER_WIDTH = gBorder.getWidth(Item.TYPE_CHOICEGROUP);
	static final int BORDER_HEIGHT = gBorder.getHeight(Item.TYPE_CHOICEGROUP);
	static final int TOTAL_BORDER_WIDTH = 2 * BORDER_WIDTH;
	static final int TOTAL_BORDER_HEIGHT = 2 * BORDER_HEIGHT;
	static final int TOTAL_BORDER_MARGIN_WIDTH = TOTAL_H_MARGIN + TOTAL_BORDER_WIDTH;
	static final int IMAGE_MARGIN_WIDTH = ChoiceElement.IMAGE_WIDTH + H_MARGIN;
	static final int MIN_CONTENT_WIDTH = ChoiceElement.SELECTION_INDICATOR_WIDTH + Font.getDefaultFont().getStringWidth("W...") + TOTAL_BORDER_MARGIN_WIDTH; //$NON-NLS-1$

	ChoiceImpl fChoice;
	IChoiceListener fListener;

	int fPrefContentHeight = -1;
	int fPrefContentWidth = -1;
	int fParentDisplayableType = -1;
	int fCachedWidth = -1;
	int fCachedHeight = -1;

	boolean fHasImage;
	boolean fFirePressed;

	ChoiceComponent(Composite parent, ChoiceImpl choice, IChoiceListener listener) {
		this(parent, choice);
		setListener(listener);
	}

	ChoiceComponent(Composite parent, ChoiceImpl choice) {
		this(parent, choice, Device.getDisplayWidth());
	}

	ChoiceComponent(Composite parent, ChoiceImpl choice, int maxWidth) {
		super(parent);
		fChoice = choice;

		fParentDisplayableType = parent.fParent.getType();
		/*
		 *  If it is a Popup Choice, the peer should be PopupChoiceButton
		 *  as set in PopupChoiceButton constructor. Don't reset it here.
		 */
		if (fParentDisplayableType != Displayable.TYPE_POPUP_CHOICE) fChoice.fPeer = this;

		fWidth = maxWidth;
		create();
	}

	void setListener(IChoiceListener listener) {
		fListener = listener;
	}

	void notifyListener(int index) {
		if (fListener != null) fListener.itemSelected(index);
	}

	public void buttonFired(ButtonWidget button) {
		int index = fComponents.indexOf(button);
		int oldIndex = fChoice.fSelectedIndex;
		int type = fChoice.fType;

		if (index == oldIndex) {
			if (type == Choice.POPUP) notifyListener(index);
			if (type != Choice.IMPLICIT) return;
		}

		if (type == Choice.MULTIPLE) {
			fChoice.updateSelectionList(index, !fChoice.isSelectedImpl(index));
		} else {
			fChoice.updateSelectionIndex(index);
			if (oldIndex != index) ((Component) fComponents.elementAt(oldIndex)).repaint();
		}
		((Component) fComponents.elementAt(index)).repaint();

		notifyListener(index);
	}

	void create() {
		disposeComponents();

		if (fChoice.fStrings == null) return;

		createElements();

		if (fParentDisplayableType != Displayable.TYPE_POPUP_MENU && fParentDisplayableType != Displayable.TYPE_POPUP_PHONE_MENU) {
			if (fChoice.fSelectedIndex != -1) {
				fFocusComponent = (Component) fComponents.elementAt(fChoice.fSelectedIndex);
			}
		}
//		if (fItem != null && fItem.fPreferredHeight != -1 &&
//			(Math.max(fItem.fPreferredHeight, getMinContentHeight()) < fPrefContentHeight))
//		{
//			createElements(Choice.TEXT_WRAP_OFF);
//		}
	}

	void createElements() {
		fHasImage = false;
		int itemCount = fChoice.fStrings.size();
		int width = fWidth - TOTAL_H_MARGIN;

		fPrefContentWidth = 0;
		for (int i = 0; i < itemCount; i++) {
			Image image = (Image) fChoice.fImageSnapshots.elementAt(i);
			fHasImage = fHasImage || image != null; // check if at least one element has an image
			ChoiceElement next = new ChoiceElement(this, fChoice, i, width);
			fPrefContentWidth = Math.max(fPrefContentWidth, next._getPreferredWidth());
		}

		if (fParentDisplayableType != Displayable.TYPE_POPUP_MENU && fParentDisplayableType != Displayable.TYPE_POPUP_PHONE_MENU) {
			if (fChoice.fSelectedIndex >= 0) ((ButtonWidget) fComponents.elementAt(fChoice.fSelectedIndex)).fHighlighted = true;
		}
	}

	Layout createLayout() {
		return new CompositeLayout(this, H_MARGIN, H_MARGIN, V_MARGIN, 0, 0);
	}

	void layout() {
		fLayout.layout();
	}

	void dispose() {
		super.dispose();

		// Dont reset if it is a PopupChoice
		if (fParentDisplayableType != Displayable.TYPE_POPUP_CHOICE) fChoice.fPeer = null;
	}

	public void delete(int index) {
		invalidate();
	}

	public void deleteAll() {
		invalidate();
	}

	void invalidate() {
		fPrefContentHeight = fPrefContentWidth = -1;
		create();
		super.invalidate();
	}

	public void insert(int index, String elementName, Image snapshot) {
		//TODO: shift focus accordingly
		invalidate();
	}

	public void set(int index, String elementName, Image snapshot) {
		invalidate();
	}

	public void setFont(int index, Font font) {
		invalidate();
	}

	public void setSelectedIndex(int index, boolean selected) {
		invalidate();
	}

	int getPreferredWidth() {
		return Device.getDisplayWidth();
	}

	int getMinimumHeight() {
		if (fPrefContentHeight == -1) {
			Enumeration elements = fComponents.elements();
			int height = TOTAL_V_MARGIN;
			while (elements.hasMoreElements()) {
				height += ((ChoiceElement) elements.nextElement()).getHeight();
			}
			fPrefContentHeight = height;
		}
		return fPrefContentHeight;
	}

	int getPreferredHeight() {
		return getMinimumHeight();
	}

	int getMinimumWidth() {
		int minWidth = MIN_CONTENT_WIDTH;
		if (fHasImage) minWidth += IMAGE_MARGIN_WIDTH;
		return minWidth;
	}

	int getType() {
		return Item.TYPE_CHOICEGROUP;
	}

	void sizeChanged(int w, int h) {
		if (fCachedWidth != w || fCachedHeight != h) {
			fCachedWidth = w;
			fCachedHeight = h;
			invalidate();
		}
	}
}
