package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

public class ChoiceGroup extends Item implements Choice {

	ChoiceImpl fChoice;

	public ChoiceGroup(String label, int type) {
		super(label);

		switch (type) {
			case Choice.POPUP:
			case Choice.MULTIPLE:
			case Choice.EXCLUSIVE: break;
			default: throw new IllegalArgumentException(MidpMsg.getString("ChoiceGroup.constructor.InvalidType")); //$NON-NLS-1$
		}

		fChoice = new ChoiceImpl(type);
	}

	public ChoiceGroup(String label, int type, String[] elements, Image[] images) {
		this(label, type);
		fChoice.setContents(elements, images);
	}

	public int append(String newString, Image newImage) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.append(newString,newImage);
		}
	}

	public void delete(int pos) {
		synchronized (Device.gDisplayableLock) {
			fChoice.delete(pos);
		}
	}

	public Image getImage(int pos) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getImage(pos);
		}
	}

	public int getSelectedFlags(boolean[] selectedArray_return) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getSelectedFlags(selectedArray_return);
		}
	}

	public int getSelectedIndex() {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getSelectedIndex();
		}
	}

	public String getString(int pos) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getString(pos);
		}
	}

	public void insert(int pos, String str, Image img) {
		synchronized (Device.gDisplayableLock) {
			fChoice.insert(pos, str, img);
		}
	}

	public boolean isSelected(int pos) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.isSelected(pos);
		}
	}

	public void set(int pos, String str, Image img) {
		synchronized (Device.gDisplayableLock) {
			fChoice.set(pos, str, img);
		}
	}

	public void setSelectedFlags(boolean[] selectedArray) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setSelectedFlags(selectedArray);
		}
	}

	public void setSelectedIndex(int pos, boolean selected) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setSelectedIndex(pos, selected);
		}
	}

	public int size() {
		synchronized (Device.gDisplayableLock) {
			return fChoice.size();
		}
	}

	public void deleteAll() {
		synchronized (Device.gDisplayableLock) {
			fChoice.deleteAll();
		}
	}

	public int getFitPolicy() {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getFitPolicy();
		}
	}

	public Font getFont(int index) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getFont(index);
		}
	}

	public void setFitPolicy(int policy) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setFitPolicy(policy);
		}
	}

	public void setFont(int index, Font font) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setFont(index, font);
		}
	}

	int getType() {
		return TYPE_CHOICEGROUP;
	}

	int getHAlignment() {
		return Item.LAYOUT_LEFT;
	}

	ItemComponent getItemComponent() {
		if (fChoice.fPeer == null) return null;
		return (ItemComponent) ((Widget) fChoice.fPeer).fParent;
	}
}
