package javax.microedition.lcdui;

import com.ibm.ive.midp.MidpMsg;

/*
 * Licensed Materials - Property of IBM.
 * (c) Copyright IBM Corp 2000, 2005.
 *
 */
public class Command {

	public static final int SCREEN = 1;
	public static final int BACK   = 2;
	public static final int CANCEL = 3;
	public static final int OK     = 4;
	public static final int HELP   = 5;
	public static final int STOP   = 6;
	public static final int EXIT   = 7;
	public static final int ITEM   = 8;

	// Label associated with command
	String fLabel;
	private int fType;
	private int fPriority;
	String fLongLabel;

	public Command(String commandLabel, int commandType, int commandPriority) {
		if (commandLabel == null) throw new NullPointerException();
		if (commandType < SCREEN || commandType > ITEM) throw new IllegalArgumentException(MidpMsg.getString("Command.constructor.WrongCommand")); //$NON-NLS-1$

		fLabel = commandLabel;
		fType = commandType;
		fPriority = commandPriority;
	}

	public Command(String shortLabel, String longLabel,  int commandType, int priority) {
		this(shortLabel, commandType, priority);
		fLongLabel = longLabel;
	}

	public int getCommandType() {
		return fType;
	}

	public String getLabel() {
		if (Alert.DISMISS_COMMAND == this) return ""; //$NON-NLS-1$
		return fLabel;
	}

	public int getPriority() {
		return fPriority;
	}

	public String getLongLabel() {
		if (Alert.DISMISS_COMMAND == this) return ""; //$NON-NLS-1$
		return fLongLabel;
	}
}
