package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;

abstract class CommandComponent extends Composite implements IButtonListener {

	static final int H_MARGIN = 2;
	static final int H_SPACING = 2;
	static final int V_MARGIN = 2;
	static final int TOTAL_V_MARGIN = 4;

	static final int MIN_WIDTH = CommandButton.DEFAULT_MIN_WIDTH;
	static final int MIN_HEIGHT = CommandButton.HEIGHT + TOTAL_V_MARGIN;

	int fVisibleCommandCount = 0;
	int fSelectedButtonIndex = -1;

	FastVector fCommands;

	CommandComponent(Composite parent) {
		super(parent);
	}

	Layout createLayout() {
		return new CompositeLayout(this, H_MARGIN, H_MARGIN, V_MARGIN, H_SPACING, 0);
	}

	void layout() {
		layoutCommands();
		super.layout();
	}

	int layoutCommands() {
		int lastCommandAdded = -1;
		fVisibleCommandCount = 0;

		fComponents.removeAllElements();

		if (fCommands == null || fCommands.size() == 0) return lastCommandAdded;
		/*
		 * Figure out whether we can layout all the commands
		 * onscreen or whether we need to use menus. If there
		 * are too many commands to be layed out onscreen, create
		 * the menus.
		 */
		int x = CommandButton.RIGHT_MARGIN;

		for (int i = 0; i < fCommands.size(); i++) {
			Command command = (Command) fCommands.elementAt(i);
			String text;
			if (i == 0) {
				/* If the first command text is longer than the width of the CommandComponent, truncate it. */
				text = format(command.fLabel, fWidth, gFont);
			} else {
				/* Other commands get put in the menu if they are too long, don't bother truncating. */
				text = command.fLabel;
			}
			CommandButton button = createButton(this, text, command);
			button.fCommand = command;
			button.setListener(this);

			/*
			 * Make sure there's room on screen for this button. If
			 * ScrollbarComponent is going to be on the same row as
			 * CommandComponent, take that into consideration. Otherwise,
			 * Command might get lost.
			 */
			int buttonWidth = fWidth == Device.getDisplayWidth() ? x + button.fWidth : x + button.fWidth + ScrollBarComponent.TOTAL_WIDTH;
			if (buttonWidth > fWidth) {
				button.dispose();
				break;
			}

			x += H_SPACING + button.fWidth;
			fVisibleCommandCount++;
			lastCommandAdded = i;
		}

		if (fVisibleCommandCount > 0) {
			fFocusComponent = (Component) fComponents.elementAt(0);
		}
		if (fSelectedButtonIndex >= fVisibleCommandCount) {
			fSelectedButtonIndex = fVisibleCommandCount - 1;
		}
		return lastCommandAdded;
	}

	public void buttonFired(ButtonWidget button) {
		dispatchCommand((CommandButton) button);
	}

	int setCommands(FastVector commands) {
		fCommands = commands;
		int lastCommand = layoutCommands();
		if (lastCommand == -1 && !getDisplayablePeer().isMidp10CanvasPeer()) {
			hide();
		} else {
			show();
		}
		return lastCommand;
	}

	int getMinimumWidth() {
		return MIN_WIDTH;
	}

	int getMinimumHeight() {
		return MIN_HEIGHT;
	}

	int getPreferredWidth() {
		return Device.getDisplayWidth();
	}

	int getPreferredHeight() {
		return getMinimumHeight();
	}

	abstract boolean traverseDown();
	abstract void dispatchCommand(CommandButton button);
	abstract CommandButton createButton(Composite parent, String text, Command command);
}
