package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

public abstract class CustomItem extends Item {

	protected static final int KEY_PRESS = 4;
	protected static final int KEY_RELEASE = 8;
	protected static final int KEY_REPEAT = 0x10;
	protected static final int POINTER_DRAG = 0x80;
	protected static final int POINTER_PRESS = 0x20;
	protected static final int POINTER_RELEASE = 0x40;
	protected static final int TRAVERSE_HORIZONTAL = 1;
	protected static final int TRAVERSE_VERTICAL = 2;

	protected static final int NONE = 0;

	CustomItemPeer fPeer;

	protected CustomItem(String label) {
		super(label);

		if (this instanceof IMediaContainerListener) {
			new ItemMediaAccessor(this);
			this.fIsMediaItem = true;
		}
	}

	public int getGameAction(int keycode) {
		return CustomItemPeer.getGameAction(keycode);
	}

	protected final int getInteractionModes() {
		return CustomItemPeer.getInteractionModes();
	}

	protected abstract int getMinContentHeight();

	protected abstract int getMinContentWidth();

	protected abstract int getPrefContentHeight(int width);

	protected abstract int getPrefContentWidth(int height);

	protected void hideNotify() {
	}

	protected final void invalidate() {
		Runnable r = new Runnable() {
			public void run() {
				if (fPeer != null) fPeer.invalidate();
			}
		};
		Device.asyncExec(r);
	}

	protected void keyPressed(int keyCode) {
	}

	protected void keyReleased(int keyCode) {
	}

	protected void keyRepeated(int keyCode) {
	}

	protected abstract void paint(Graphics graphics, int width, int height);

	protected void pointerDragged(int x, int y) {
	}

	protected void pointerPressed(int x, int y) {
	}

	protected void pointerReleased(int x, int y) {
	}

	protected final void repaint() {
		if (fPeer != null) fPeer.repaint();
	}

	protected final void repaint(final int x, final int y, final int width, final int height) {
		if (fPeer != null) fPeer.scheduleRepaint(x, y, width, height);
	}

	protected void showNotify() {
	}

	protected void sizeChanged(int width, int height) {
	}

	protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
		return false;
	}

	protected void traverseOut() {
	}

	int getType() {
		return Item.TYPE_CUSTOM;
	}

	/*
	 * Overriden by subclasses which are part of the peer hierarchy.
	 */
	Item getSelectedItem() {
		return this;
	}

	ItemComponent getItemComponent() {
		if (fPeer == null) return null;
		return (ItemComponent) fPeer.fParent;
	}
}
