package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006 All Rights Reserved
 */

import java.util.*;
import com.ibm.ive.midp.*;

class DateFieldPeer extends Win32Component implements IEventListener {

	DateField fDateField;
	int fDateHandle;
	int fTimeHandle;
	Date fCachedDate;
	boolean fGetDate;
	boolean fInNullState;
	int fMinContentHeight = 25;
	int fMinContentWidth = 90;

	public static final int HMARGIN = 40;
	public static final int VMARGIN = 10;

	static native int createDate(int parent, int flags);
	static native void getDateFieldTextSize(int handle, int[] size);

	DateFieldPeer(Composite parent, final DateField dateField) {
		super(parent);
		fDateField = dateField;
		fDateField.fPeer = this;

		fInNullState = true;

		Device.syncExec(new Runnable() {
			public void run() {
				createWindows();
				setDate(dateField.fDate);

				int[] size = new int[2];
				if (fDateHandle != 0) {
					getDateFieldTextSize(fDateHandle, size);
					fMinContentWidth = Math.max(fMinContentWidth, size[0] + HMARGIN);
					fMinContentHeight = Math.max(fMinContentHeight, size[1] + VMARGIN);
				}
				if (fTimeHandle != 0) {
					getDateFieldTextSize(fTimeHandle, size);
					fMinContentWidth = Math.max(fMinContentWidth, size[0] + HMARGIN);
					fMinContentHeight = Math.max(fMinContentHeight, size[1] + VMARGIN);
				}
			}
		});
	}

	void setFormatStrings() {
		Device.syncExec(new Runnable() {
			public void run() {
				if (fInNullState) {
					if (fDateHandle != 0) {
						String dateString = MsgDrawnCommon.getString("DateFieldPeer.DateString");  //$NON-NLS-1$
						OS.SendMessageW(fDateHandle, OS.DTM_SETFORMATW, 0, "'" + dateString + "'");
					}
					if (fTimeHandle != 0){
						String timeString = MsgDrawnCommon.getString("DateFieldPeer.TimeString");  //$NON-NLS-1$
						OS.SendMessageW(fTimeHandle, OS.DTM_SETFORMATW, 0, "'" + timeString + "'");
					}
				} else {
					if (fDateHandle != 0) OS.SendMessageW(fDateHandle, OS.DTM_SETFORMATW, 0, "M'/'dd'/'yyyy"); //$NON-NLS-1$
					if (fTimeHandle != 0) OS.SendMessageW(fTimeHandle, OS.DTM_SETFORMATW, 0, "hh':'mm' 'tt"); //$NON-NLS-1$
				}
			}
		});
	}

	void createWindows() {
		int formHandle = ((FormContentComponent) ((FormPeer)getDisplayablePeer()).fContentComponent).fHandle;
		switch (fDateField.fInputMode) {
			case DateField.DATE:
				fDateHandle = createDate(formHandle, getFlags());
				break;
			case DateField.TIME:
				fTimeHandle = createDate(formHandle, getFlags());
				break;
			case DateField.DATE_TIME:
				fDateHandle = createDate(formHandle, getFlags() | OS.DTS_SHORTDATEFORMAT);
				fTimeHandle = createDate(formHandle, getFlags() | OS.DTS_TIMEFORMAT);
				break;
		}
		if (fDateHandle != 0) Device.addEventListener(this, fDateHandle);
		if (fTimeHandle != 0) Device.addEventListener(this, fTimeHandle);
	}

	void paint(Graphics g) {
		Device.asyncExec(new Runnable() {
			public void run() {
				if (fDateHandle != 0) OS.InvalidateRect(fDateHandle, true);
				if (fTimeHandle != 0) OS.InvalidateRect(fTimeHandle, true);
			}
		});
	}

	void showNotify() {
		Device.syncExec(new Runnable() {
			public void run() {
				if (fTimeHandle != 0) OS.ShowWindow(fTimeHandle, OS.SW_SHOW);
				if (fDateHandle != 0) OS.ShowWindow(fDateHandle, OS.SW_SHOW);
			}
		});
	}

	void hideNotify() {
		if (fDateHandle != 0) OS.ShowWindow(fDateHandle, OS.SW_HIDE);
		if (fTimeHandle != 0) OS.ShowWindow(fTimeHandle, OS.SW_HIDE);
	}

	void sizeChanged(final int w, final int h) {
		final DateFieldPeer peer = this;
		Device.asyncExec(new Runnable() {
			public void run() {
				int flags = OS.SWP_NOZORDER | OS.SWP_DRAWFRAME | OS.SWP_NOACTIVATE;
				/*
				* Feature on WinCE.  The SWP_DRAWFRAME flag for SetWindowPos()
				* causes a WM_SIZE message to be sent even when the SWP_NOSIZE
				* flag is specified.  The fix is to clear SWP_DRAWFRAME.
				*/
				if (OS.IsWinCE) {
					if ((flags & OS.SWP_NOSIZE) != 0) flags &= ~OS.SWP_DRAWFRAME;
				}
				int x = fParent.getOriginX(peer);
				int y = fParent.getOriginY(peer);
				if (fDateField.fInputMode == DateField.DATE_TIME) {
					OS.SetWindowPos(fDateHandle, 0, x , y, fMinContentWidth, getHeight(), flags);
					OS.SetWindowPos(fTimeHandle, 0, x + fMinContentWidth + 5, y, fMinContentWidth, getHeight(), flags);
				} else {
				 	if (fDateHandle !=0) OS.SetWindowPos(fDateHandle, 0, x , y, fWidth, getHeight(), flags);
					if (fTimeHandle !=0) OS.SetWindowPos(fTimeHandle, 0, x , y, fWidth, getHeight(), flags);
				}
				show();
			}
		});
	}

	int getHeight() {
		return fHeight;
	}

	void updatePosition() {
		final Win32Component peer = this;
		Device.asyncExec(new Runnable() {
			public void run() {
				int x = fParent.getOriginX(peer);
				int y = fParent.getOriginY(peer);
				int flags = OS.SWP_NOZORDER | OS.SWP_DRAWFRAME | OS.SWP_NOACTIVATE;
				if (fDateField.fInputMode == DateField.DATE_TIME) {
					OS.SetWindowPos(fDateHandle, 0, x , y, fMinContentWidth, fHeight, flags);
					OS.SetWindowPos(fTimeHandle, 0, x + fMinContentWidth + 5, y, fMinContentWidth, fHeight, flags);
		 		} else {
					if (fDateHandle != 0) OS.SetWindowPos(fDateHandle, 0, x , y, fWidth, fHeight, flags);
					if (fTimeHandle != 0) OS.SetWindowPos(fTimeHandle, 0, x , y, fWidth, fHeight, flags);
		 		}
			}
		});
	}

	int getFlags() {
		int bits = OS.WS_CHILD | OS.WS_VISIBLE | OS.WS_BORDER;
		switch (fDateField.fInputMode) {
			case DateField.DATE :
				bits = bits | OS.DTS_SHORTDATEFORMAT;
				break;
			case DateField.TIME :
				bits = bits | OS.DTS_TIMEFORMAT;
				break;
		}
		return bits;
	}

	void dispose() {
		fGetDate = false;
		super.dispose();

		if (fDateHandle != 0) {
			Device.removeEventListener(this, fDateHandle);
			Device.syncExec(new Runnable() {
				public void run() {
					OS.DestroyWindow(fDateHandle);
				}
			});
			fDateHandle = 0;
		}
		if (fTimeHandle != 0) {
			Device.removeEventListener(this, fTimeHandle);
			Device.syncExec(new Runnable() {
				public void run() {
					OS.DestroyWindow(fTimeHandle);
				}
			});
			fTimeHandle = 0;
		}
		fDateField.fPeer = null;
	}

	void setDate(Date date) {
		Calendar calendar = null;
		if (date != null) {
			calendar = fDateField.getCalendar();
			calendar.setTime(date);
		}
		setDate(calendar);
	}

	public void setDate(Calendar c) {
		if (c != null) {
			short[] systemTime = new short[8];
			// set the date into the system time
			systemTime[0]=(short)c.get(Calendar.YEAR);
			// January starts at 0 rather than 1
			systemTime[1]= (short) (c.get(Calendar.MONTH) + (1 - Calendar.JANUARY));
			// Sunday start at 1 rather than 0
			systemTime[2]=(short) (c.get(Calendar.DAY_OF_WEEK) + (0 - Calendar.SUNDAY));
			systemTime[3]=(short)c.get(Calendar.DAY_OF_MONTH);
			// set the time into the system time
			// use 24 hour time of day
			systemTime[4]=(short)c.get(Calendar.HOUR_OF_DAY);
			systemTime[5]=(short)c.get(Calendar.MINUTE);
			systemTime[6]=(short)c.get(Calendar.SECOND);
			systemTime[7]=(short)c.get(Calendar.MILLISECOND);
			// get the time portion of the date (to avoid timezone conversions)
			if (fDateHandle != 0) OS.SendMessageW(fDateHandle, OS.DTM_SETSYSTEMTIME, 0, systemTime);
			if (fTimeHandle != 0) OS.SendMessageW(fTimeHandle, OS.DTM_SETSYSTEMTIME, 0, systemTime);
			fDateField.fDate = c.getTime();
			fInNullState = false;
		} else {
			fDateField.fDate = null;
			fInNullState = true;
			fGetDate = false;
		}
		 if (fCachedDate != fDateField.fDate && (fCachedDate == null || !fCachedDate.equals(fDateField.fDate))) {
			fCachedDate = fDateField.fDate;
		}
		setFormatStrings();
	}

	void destroyHandles() {
		if (fDateHandle != 0) {
			OS.DestroyWindow(fDateHandle);
			fDateHandle = 0;
		}
		if (fTimeHandle != 0) {
			OS.DestroyWindow(fTimeHandle);
			fTimeHandle = 0;
		}
	}

	void updateInputMode() {
		destroyHandles();
		createWindows();
		setFormatStrings();
		sizeChanged(fWidth, fHeight);
	}

	int getMinimumHeight() {
		return fMinContentHeight;
//		final int[] retValue = new int[1];
//		Device.syncExec(new Runnable() {
//			public void run() {
//				if (fDateHandle != 0) retValue[0] = OS.GetWindowHeight(fDateHandle);
//				if (fTimeHandle != 0) retValue[0] += OS.GetWindowHeight(fTimeHandle);
//
//			}
//		});
//
//		System.err.println("Window height: " + retValue[0]);
//		return retValue[0];
	}

	int getMinimumWidth() {
		int width = 0;
		if (fDateHandle != 0) width += fMinContentWidth;
		if (fTimeHandle != 0) width += fMinContentWidth;
		return width;
//		final int[] retValue = new int[1];
//		Device.syncExec(new Runnable() {
//			public void run() {
//				if (fDateHandle != 0) retValue[0] = OS.GetWindowWidth(fDateHandle);
//				if (fTimeHandle != 0) retValue[0] += OS.GetWindowWidth(fTimeHandle);
//			}
//		});
//		System.err.println("Window width: " + retValue[0]);
//		return retValue[0];
	}

	Date getCurrentDate() {
		final Calendar c = Calendar.getInstance();
		if (fDateField.fTimeZone != null) c.setTimeZone(fDateField.fTimeZone);
		if (fCachedDate != null) c.setTime(fCachedDate);
		Device.syncExec(new Runnable() {
			public void run() {
				if (fDateHandle != 0 && fTimeHandle != 0) {
					int[] date = new int[5];
					int[] time = new int[5];
					OS.DateTime_GetSystemTime(fDateHandle, date);
					OS.DateTime_GetSystemTime(fTimeHandle, time);
					c.set(Calendar.YEAR, date[0]);
					c.set(Calendar.MONTH, date[1] - 1);
					c.set(Calendar.DAY_OF_MONTH, date[2]);
					c.set(Calendar.HOUR_OF_DAY, time[3]);
					c.set(Calendar.MINUTE, time[4]);
				} else if (fDateHandle != 0) {
					int[] date = new int[5];
					OS.DateTime_GetSystemTime(fDateHandle, date);
					c.set(Calendar.YEAR, date[0]);
					c.set(Calendar.MONTH, date[1] - 1);
					c.set(Calendar.DAY_OF_MONTH, date[2]);
					c.set(Calendar.HOUR_OF_DAY, 00);
					c.set(Calendar.MINUTE, 00);
				} else {
					int[] time = new int[5];
					OS.DateTime_GetSystemTime(fTimeHandle, time);
					c.set(Calendar.YEAR, 1970);
					c.set(Calendar.MONTH, 01-1);
					c.set(Calendar.DAY_OF_MONTH, 01);
					c.set(Calendar.HOUR_OF_DAY, time[3]);
					c.set(Calendar.MINUTE, time[4]);
				}
			}
		});
		return c.getTime();
	}

	Date getDate() {
		return fDateField.fDate;
	}

	public boolean dispatchEvent(Event e) {
		if (e.fType == Event.VERTICAL_SCROLL) {
			if (fInNullState) {
				fInNullState = false;
				fGetDate = true;
				setFormatStrings();
			}
			fParent.setFocus(this);
			return false;
		}
		if (e.fType == OS.WM_KEYDOWN || e.fType == OS.WM_KEYUP) {
			if (!(fCachedDate == null && fDateField.fDate == null) && (OS.GetFocus() == fDateHandle || OS.GetFocus() == fTimeHandle)) {
				fGetDate = true;
			}
			if (e.fKeyCode == OS.VK_DOWN || e.fKeyCode == OS.VK_UP || e.fKeyCode == OS.VK_RETURN) {
			 	getDisplay().fPeer.dispatchEvent(e);
			 	return true;
			 }
		}
		return false;
	}

	public boolean dispatchPointerEvent(Event e) {
		if (e.fType == Event.POINTER_PRESSED) fGetDate = true;
		return super.dispatchPointerEvent(e);
	}

	public boolean getAllowMenuEvents() {
		return false;
	}

	boolean keyPressed(int keyCode) {
		int x = fMinContentWidth - 10;
		int y = fMinContentHeight / 2;
		int lParam = x + y * 0x00010000;
		if (keyCode == Canvas.KEYCODE_FIRE && OS.GetFocus() == fDateHandle) {
			OS.SendMessageW(fDateHandle, OS.WM_LBUTTONDOWN, 1, lParam);
			return true;
		}
		return super.keyPressed(keyCode);
	}

	boolean traverse(int direction, int viewWidth, int viewHeight, int[] visibleRectangle, int x, int y) {

		/*
		 * Dispose the PopupChoice window if it is the one that is currently showing up.
		 * Need to check if there is a cleaner way to do this. This is more or less
		 * a hack that is good enough for now.
		 */
		DisplayPeer peer = getDisplayPeer();
		if (peer.fCurrentWindow instanceof PopupChoice) {
			peer.fCurrentWindow.dispose();
		}

		int calHandle = OS.SendMessageW(fDateHandle, OS.DTM_GETMONTHCAL, 0, 0);
		if (calHandle == 0) {
			if (!hasFocus()) {
				/* Initial traversal event */
				switch (direction) {
					case Canvas.UP:
						/* Set focus to Time field if possible. */
						Device.syncExec(new Runnable() {
							public void run() {
								if (fDateField.fInputMode == DateField.DATE) {
									OS.SetFocus(fDateHandle);
								} else {
									OS.SetFocus(fTimeHandle);
								}
							}
						});

						return true;
					case Canvas.DOWN:
						/* Set focus to Date field if possible. */
						Device.syncExec(new Runnable() {
							public void run() {
								if (fDateField.fInputMode == DateField.TIME) {
									OS.SetFocus(fTimeHandle);
								} else {
									OS.SetFocus(fDateHandle);
								}
							}
						});

						return true;
				}
			}
		   	/* Subsequent traversal events */
			switch (direction) {
				case Canvas.UP:
					if (fDateField.fInputMode == DateField.DATE_TIME && OS.GetFocus() == fTimeHandle) {
						OS.SetFocus(fDateHandle);
						return true;
					}
					return false;
				case Canvas.DOWN:
					if (fDateField.fInputMode == DateField.DATE_TIME && OS.GetFocus() == fDateHandle) {
						OS.SetFocus(fTimeHandle);
						return true;
					}
					return false;
			}
		} else {
			OS.SetFocus(calHandle);
			return true;
		}
		if (fDateField.fInputMode == DateField.TIME) {
			OS.SetFocus(fTimeHandle);
			OS.InvalidateRect(fTimeHandle, true);
		} else {
			OS.SetFocus(fDateHandle);
			OS.InvalidateRect(fDateHandle, true);
		}
		return true;
	}

	void traverseOut() {
		int handle = OS.GetFocus();
		if (handle == 0 || handle == fDateHandle || handle == fTimeHandle) {
			OS.SetFocus(getDisplayablePeer().getWindowHandle());
		}

		/*
		 * fDateField.fDate is updated only if the date
		 * has been changed using a keypress or if the calendar
		 * has been accessed
		 */
		if (fGetDate) {
			fDateField.fDate = getCurrentDate();
			fGetDate = false;
		}

		if (fCachedDate != fDateField.fDate && (fCachedDate == null || !fCachedDate.equals(fDateField.fDate))) {
			fCachedDate = fDateField.fDate;
			fDateField.notifyStateChanged();
		}
	}
}
