package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

class FillContentComponent extends Scrollable {

	Component fComponent;

	FillContentComponent(Window parent) {
		super(parent);

		fFocusComponent = fComponent = createContents();

		fFocusComponent.fLayoutData |= Item.LAYOUT_2 | Item.LAYOUT_VEXPAND;
		fExpandVertically = true;
	}

	Component createContents() {
		switch (fParent.getType()) {
			case Displayable.TYPE_TEXTBOX: {
					TextImpl textImpl = ((TextBox) fParent.getDisplayable()).fText;
					TextField textField = new TextField(null, textImpl.getString(), textImpl.getMaxSize(), textImpl.getConstraints());
					textField.fText = textImpl;
					textField.fScreen = (Screen) fParent.getDisplayable();
					return new ItemComponent(this, textField);
				}
		}
		return null;
	}

	Component getContents() {
		return fComponent;
	}

	boolean canScrollUp() {
		return fScrollY > 0;
	}

	boolean canScrollDown() {
		return fScrollY + fHeight < getContents().getPreferredHeight();
	}

	boolean isScrollable() {
		return getContents().getPreferredHeight() > fHeight;
	}

	void ensureVisible(Component c, int[] rect) {
		/*
		 * For Textbox, we handle scrolling through TextPeer.scrollIfNecessary().
		 * So We don't have to call ensureVisible() for TextBox
		 */
		if (fParent.getType() != Displayable.TYPE_TEXTBOX) {
			super.ensureVisible(c, rect);
		}
	}
}
