package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class FormContentComponent extends Scrollable implements IEventListener {

	FormPeer fFormPeer;
	Graphics fGraphics;
	Image fContentBuffer;
	int fHandle = 0;
	int fContentWidth = -1;

	boolean fMousePressed = false;

	static final int MARGIN = 2;

	FormContentComponent(FormPeer peer) {
		super(peer);
		fFormPeer = peer;

		Device.syncExec(new Runnable() {
			public void run() {
				fHandle = OS.CreateChildWindow(fFormPeer.getWindowHandle(), getContentFlags());
			}
		});
		addContentWindowEventListener();

		/*
		 * We have to set this field before creating items because they reference
		 * the content component when they're created.
		 */
		peer.fContentComponent = this;

		Item[] items;
		int length;
		if (fFormPeer.fDisplayable.getDisplayableType() == Displayable.TYPE_ALERT) {
			items = ((Alert) fFormPeer.fDisplayable).fItems;
			length = ((Alert) fFormPeer.fDisplayable).fItemsLength;
		} else {
			items = ((Form) fFormPeer.fDisplayable).fItems;
			length = ((Form) fFormPeer.fDisplayable).fItemsLength;
		}
		if (items == null) return;

		for (int i = 0; i < length; i++) {
			new ItemComponent(this, items[i]);
		}

		int largestDimension = Math.max(Device.getShellWidth(), Device.getShellHeight());
		fContentBuffer = Image.createImage(largestDimension, largestDimension);
		fGraphics = new Graphics(this);
	}

	Image getOffscreenBuffer() {
		return fContentBuffer;
	}

	int getOriginX() {
		return 0;
	}

	int getOriginY() {
		return 0;
	}

	int getOriginX(Component child) {
		return child.fX - fScrollX;
	}

	int getOriginY(Component child) {
		return child.fY - fScrollY;
	}

	Layout createLayout() {
		return new CompositeLayout(this, MARGIN, MARGIN, MARGIN, MARGIN, MARGIN);
	}

	boolean isScrollable() {
		return fLayout.fLayoutHeight > fHeight;
	}

	boolean canScrollUp() {
		return fScrollY > 0;
	}

	boolean canScrollDown() {
		return fScrollY + fHeight < fLayout.fLayoutHeight;
	}

	int getContentFlags() {
		int bits = OS.WS_CHILD | OS.WS_VISIBLE | OS.WS_CLIPCHILDREN;
		bits |= OS.ES_NOHIDESEL | OS.ES_AUTOVSCROLL;
		bits &= ~OS.WS_HSCROLL;
		return bits;
	}

	public void addContentWindowEventListener() {
		Device.addEventListener(this, fHandle);
	}

	public boolean dispatchEvent(Event e) {
		switch (e.fType) {
//			case Event.MENU_SELECTED:
//				int type = (e.fArg1 & 0xFFFF0000) >> 16;
//				Item selectedItem = fFormPeer.getSelectedItem();
//				if (selectedItem != null && selectedItem.getType() == Item.TYPE_CHOICEGROUP) {
//					if (type == OS.CBN_SELCHANGE) {
//						ChoiceGroup choiceGroup = (ChoiceGroup) selectedItem;
//						((PopupChoiceButton)choiceGroup.fChoice.fPeer).selectionChanged();
//					} else if (type == OS.CBN_CLOSEUP) {
//						// ComboBox closing. Set the drop down state to false
//						ChoiceGroup choiceGroup = (ChoiceGroup) selectedItem;
//						((PopupChoiceButton)choiceGroup.fChoice.fPeer).fInDropDownState = false;
//						selectedItem.notifyStateChanged();
//					}
//				}
//				return false;
			case Event.WINDOW_PAINT:
				if (!fFormPeer.fInvalidated) fFormPeer.repaint();
				return false;
			case Event.VERTICAL_SCROLL:
				if (fFormPeer.isShown()) {
					int scrollY = e.fScrollOrSelectionIndex - fScrollY;
					scroll(0, scrollY);
				}
				return false;
			case Event.WINDOW_RESIZE:
				if (e.fX <= 0) return false;
				clearCachedSizes();
				int newWidth = e.fX;
				if (newWidth == fContentWidth) return false;
				fContentWidth = newWidth;
				fWidth = newWidth;
				fFormPeer.layout();
				updateScrollBar();
				fFormPeer.repaint();
				return false;
			case Event.DATE_CALENDAR_CLOSE:
				if (fFocusComponent != null && fFocusComponent instanceof ItemComponent) {
					ItemComponent itemComp = (ItemComponent) fFocusComponent;
					if (itemComp.fFocusComponent != null && itemComp.fFocusComponent instanceof DateFieldPeer) {
						DateFieldPeer peer = (DateFieldPeer) itemComp.fFocusComponent;
						// If it is in null state, set the date
						if (peer.fInNullState) {
							peer.fInNullState = false;
							peer.setFormatStrings();
						}
					}
				}
				return false;
		}
		return false;
	}

	public boolean dispatchPointerEvent(Event e) {
		switch (e.fType) {
			case Event.POINTER_PRESSED:
				fMousePressed = true;
				if (Device.canGrabPointer()) Device.gCanUpdate = false;
				if (fFormPeer.isShown()) {
					return pointerPressed(e.fX, e.fY);
				}

				DisplayPeer displayPeer = getDisplayPeer();
				if (displayPeer.fCurrentWindow != fFormPeer) {
					return displayPeer.dispatchPointerEvent(e);
				}
				return false;
			case Event.POINTER_RELEASED:
				fMousePressed = false;
				if (Device.canGrabPointer()) Device.gCanUpdate = true;
				if (fFormPeer.isShown()) {
					return pointerReleased(e.fX, e.fY);
				}
				return false;
			case Event.POINTER_MOVED:
				if (!fMousePressed) return false;
				if (fFormPeer.isShown()) {
					return pointerDragged(e.fX, e.fY);
				}
				return false;
			default:
				return false;
		}
	}

	public boolean getAllowMenuEvents() {
		return false;
	}

//	public void setBounds(final Rectangle bounds) {
////		if (bounds.equals(getBounds())) return;
//
//		super.setBounds(bounds);
//
//		final FormContentComponent content = this;
//		Device.syncExec(new Runnable() {
//			public void run() {
////				System.err.println("FormContentComponent setBounds: " + fGraphics + " - " + content);
//				if (fGraphics != null) {
////					System.err.println("FormContentComponent setBounds disposing graphics");
//					fGraphics.dispose();
//				}
//				if (fContentBuffer != null) fContentBuffer.dispose();
//				int width = Math.max(1, bounds.width);
//				int height = Math.max(1, bounds.height);
//				fContentBuffer = Image.createImage(width, height);
///*[IF NATIVE_WIDGETS]
//				fGraphics = new Graphics(content);
////				System.err.println("FormContentComponent created graphics: " + fGraphics);
///*[ENDIF]*/
//				OS.SetWindowPos(fHandle, 0, bounds.x, bounds.y, bounds.width, bounds.height, 0);
//			}
//		});
//	}

	public void dispose() {
		super.dispose();

		Device.removeEventListener(this, fHandle);
		Device.asyncExec(new Runnable() {
			public void run() {
				if (fHandle != 0) {
					OS.DestroyWindow(fHandle);
					fHandle = 0;
				}
			}
		});
		if (fGraphics != null) {
			fGraphics.dispose();
			fGraphics = null;
		}
		if (fContentBuffer != null) {
			fContentBuffer.dispose();
			fContentBuffer = null;
		}
	}

	public void setVisible(boolean visible) {
		int flags = visible ? OS.SW_SHOW : OS.SW_HIDE;
		OS.ShowWindow(fHandle, flags);
	}

	public Graphics getGraphics() {
		return fGraphics;
	}

	public GraphicsThreadsafe getDisplayGraphics() {
		final GraphicsThreadsafe[] g = new GraphicsThreadsafe[1];
		final FormContentComponent content = this;
		Device.syncExec(new Runnable() {
			public void run() {
				g[0] = new GraphicsThreadsafe(content);
			}
		});
		return g[0];
	}

	public int getClientAreaWidth() {
		if (fHandle == 0) return 0;
		return OS.GetClientWidth(fHandle);
	}

	public void scrollSelectedItemIntoView() {
		if (getDisplayablePeer().fDisplayable.getDisplayableType() == Displayable.TYPE_FORM) {
			if (fLayout.fLayoutHeight < fHeight) {
				fScrollY = 0;
				return;
			}

			Item item = ((Form) fFormPeer.fDisplayable).fCurrentItem;
			if (item == null) return;
			Component c = item.getItemComponent();
			ensureVisible(c, new int[] {c.fX, c.fY, c.fWidth, c.fHeight});
		}
	}

	void paintComponents(Graphics g) {
		if (isInvalidated()) return;

		// Clear the graphics
		g.setColor(DisplayPeer.COLOR_DISPLAYABLE_BACKGROUND_RGB);
		g.fillRect(0, 0, fWidth, fHeight);

		super.paintComponents(g);

		fGraphics.flush();
	}

	void layout() {
		super.layout();
		if (fLayout.fLayoutHeight - fScrollY < fHeight) {
			fScrollY = Math.max(0, fLayout.fLayoutHeight - fHeight);
		}

		Device.syncExec(new Runnable() {
			public void run() {
				OS.SetWindowPos(fHandle, 0, fX, fY, fWidth, fHeight, 0);
			}
		});
	}

	void updateItemValues() {
		int componentsLength = fComponents.size();
		for (int i = 0; i < componentsLength; i++) {
			((ItemComponent) fComponents.elementAt(i)).update();
		}
	}

	void hideNotify() {
		((CompositeLayout) fLayout).hideNotify();
	}

	boolean scroll(int deltaX, int deltaY) {
		if (super.scroll(deltaX, deltaY)) {
			int componentsLength = fComponents.size();
			for (int i = 0; i < componentsLength; i++) {
				((ItemComponent) fComponents.elementAt(i)).fContentComponent.updatePosition();
			}
			return true;
		}
		return false;
	}

	int getWindowHandle() {
		return fHandle;
	}

	int getContentWidth() {
		if (fContentWidth == -1) return fWidth;
		return fContentWidth;
	}

	void setFocus(Component c) {
		boolean hadFocusAlready = c == fFocusComponent;
		super.setFocus(c);
		if (hadFocusAlready) return;
		Displayable displayable = getDisplayable();
		if (fFocusComponent instanceof ItemComponent && displayable instanceof Form) {
			Item item = ((ItemComponent) fFocusComponent).fItem;
			Form form = (Form) displayable;
			form.fCurrentItem = item;
			form.fPeer.fCommandManager.focusChanged(fFocusComponent);
		}
	}

	void updateFormContent() {
		Item[] items;
		int length;

		fShown = false;
		if (fFormPeer.fDisplayable.getDisplayableType() == Displayable.TYPE_ALERT) {
			items = ((Alert) fFormPeer.fDisplayable).fItems;
			length = ((Alert) fFormPeer.fDisplayable).fItemsLength;
		} else {
			items = ((Form) fFormPeer.fDisplayable).fItems;
			length = ((Form) fFormPeer.fDisplayable).fItemsLength;
		}

		ItemComponent componentArray[] = new ItemComponent[length];
		for (int i = 0; i < length; i++) {
			ItemComponent itemComponent = items[i].getItemComponent();

			// ItemComponent not there. This means this is a newly added Item
			if (itemComponent == null) {
				itemComponent = new ItemComponent(this, items[i]);
				fComponents.removeElement(itemComponent);
			}
			componentArray[i] = itemComponent;
		}

		// Dispose ItemComponents that are no more required.
		int size = fComponents.size();
		boolean focusComponentRemoved = false;
		int focusComponentIndex = -1;
		for (int i = size - 1; i >= 0; i--) {
			ItemComponent itemComponent = (ItemComponent) fComponents.elementAt(i);
			boolean remove = true;
			for (int j = 0; j < length; j++) {
				if (componentArray[j] == itemComponent) {
					remove = false;
					break;
				}
			}
			if (remove) {
				/*
				 * If the Item had the focus, then we might need
				 * to remove the Item menu
				 */
				if (fFormPeer.fCommandManager.fItemMenuItem == itemComponent) {
					fFormPeer.fCommandManager.focusChanged(null);
				}
				if (itemComponent == fFocusComponent) {
					fFocusComponent = null;
					if (fFormPeer.fFocusComponent == this) {
						focusComponentRemoved = true;
						focusComponentIndex = i;
					}
				}
				itemComponent.dispose();
			}
		}

		fComponents.removeAllElements();
		for (int i = 0; i < length; i++) fComponents.addElement(componentArray[i]);

		/*
		 * If the Item that currently had focus has been removed, set the
		 * focus to the next Item.
		 */
		if (focusComponentRemoved && componentArray.length > 0) {
			Form form = (Form) getDisplayable();
			if (focusComponentIndex >= componentArray.length) focusComponentIndex = 0;

			form.fCurrentItem = componentArray[focusComponentIndex].fItem;
			fFormPeer.setInitialFocus();
		}
		fShown = true;
	}
}

