package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class FormPeer extends DisplayablePeer {

	public FormPeer(Display display, Screen screen) {
		super(display, screen);
	}

	void setInitialFocus() {
		Form form = (Form) fDisplayable;
		if (form.fCurrentItem != null && (fFocusComponent == fContentComponent || fFocusComponent == null)) {
			// if the form set the current item, switch to it
			ItemComponent component = form.fCurrentItem.getItemComponent();
			if (component != null) {
				component.traverse(CustomItem.NONE, 0, 0, new int[] {0, 0, component.fWidth, component.fHeight}, component.fContentComponent.fX, component.fContentComponent.fY);
				((FormContentComponent) fContentComponent).scrollSelectedItemIntoView();
				return;
			}
		}
		super.setInitialFocus();
	}

	public void hideNotify() {
		((FormContentComponent) fContentComponent).hideNotify();
	}

	public void resize(int newWidth, int newHeight) {
		if (isDisposed()) return;
		((FormContentComponent) fContentComponent).clearCachedSizes();
		super.resize(newWidth, newHeight);
		((FormContentComponent) fContentComponent).scrollSelectedItemIntoView();
	}

	public void setCurrentItem(final Item item) {
		Device.syncExec(new Runnable() {
			public void run() {
				// if the form set the current item, switch to it
				ItemComponent itemComponent = item.getItemComponent();
				itemComponent.traverse(CustomItem.NONE, 0, 0, new int[] {0, 0, itemComponent.fWidth, itemComponent.fHeight}, itemComponent.fContentComponent.fX, itemComponent.fContentComponent.fY);
				((FormContentComponent) fContentComponent).scrollSelectedItemIntoView();
			}
		});
	}

	public Item getSelectedItem() {
		ItemComponent component = (ItemComponent) fContentComponent.getFocus();
		if (component == null) return null;
		return component.fItem;
	}

	void update() {
		if (!fUpdateScheduled) return;

		synchronized (Device.gDisplayableLock) {
			if (fDisposed) return;

			//Added/Removed items
			if ((fUpdateType & ITEMS_CHANGED) != 0) {
				fUpdateType &= ~ITEMS_CHANGED;
				fInvalidated = true;

				((FormContentComponent) fContentComponent).updateFormContent();
			 	fInvalidated = false;

				fContentComponent.layout();
				setInitialFocus();
				fContentComponent.repaint();
			}

		 	//Process other updates
		 	if (fUpdateType != 0)  {
				super.update();
			} else {
				fUpdateScheduled = false;
			}
		}
	}
}
