package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

public class Gauge extends Item {

	public static final int CONTINUOUS_IDLE = 0;
	public static final int CONTINUOUS_RUNNING = 2;
	public static final int INCREMENTAL_IDLE = 1;
	public static final int INCREMENTAL_UPDATING = 3;
	public static final int INDEFINITE = -1;

	boolean fInteractive;
	int fMax;
	int fValue;

	GaugePeer fPeer;

	public Gauge(String gaugeLabel, boolean interactive, int max, int initial) {
		super(gaugeLabel);

		fInteractive = interactive;

		if (fInteractive) {
			if (max <= 0) throw new IllegalArgumentException();
		} else {
			if (max <= 0 && max != INDEFINITE) throw new IllegalArgumentException();
			if (max == INDEFINITE && (initial < 0 || initial > 3)) throw new IllegalArgumentException();
		}

		fMax = max;

		if (fInteractive || (!fInteractive && fMax != INDEFINITE)) {
			fValue = (initial > fMax) ? fMax : initial;
			fValue = (fValue < 0) ? 0 : fValue;
		} else {
			fValue = initial;
		}
	}

	public int getMaxValue() {
		synchronized (Device.gDisplayableLock) {
			return fMax;
		}
	}

	public int getValue() {
		synchronized (Device.gDisplayableLock) {
			return fValue;
		}
	}

	public boolean isInteractive() {
		synchronized (Device.gDisplayableLock) {
			return fInteractive;
		}
	}

	public void setMaxValue(int max) {
		if (fInteractive) {
			if (max <= 0) throw new IllegalArgumentException();
		} else {
			if (max <= 0 && max != INDEFINITE) throw new IllegalArgumentException();
		}

		synchronized (Device.gDisplayableLock) {
			if (!fInteractive && fMax != INDEFINITE && max == INDEFINITE) {
				fValue = Gauge.CONTINUOUS_IDLE ;
			} else if (fInteractive || (!fInteractive && max != INDEFINITE)) {
				if (fValue > max) {
					fValue = max;
				}
			}

			fMax = max;

			if (fPeer != null) fPeer.newMaxValue(fMax);
		}
	}

	public void setValue(int value) {
		synchronized (Device.gDisplayableLock) {
			_setValue(value);
		}
	}

	void _setValue(int value) {
		if (!fInteractive && fMax == INDEFINITE) {
			if (value < 0 || value > 3) throw new IllegalArgumentException();
			if (fPeer != null) fPeer.incrementAnimationState();
			fValue = value;
		} else {
			if (value == fValue) return;
			fValue = (value > fMax) ? fMax : value;
			fValue = (fValue < 0) ? 0 : fValue;
		}

		if (fScreen != null && fScreen.fPeer != null) {
			fScreen.fPeer.scheduleUpdate(FormPeer.ITEM_VALUE_CHANGED);
		}
	}

	boolean isAlertCompatible() {
		return !fInteractive &&
		    	getScreen() == null &&
		    	(fCommands == null || fCommands.size() == 0) &&
		    	fCommandListener == null &&
		    	getLabel() == null &&
		    	(fPreferredHeight == -1 && fPreferredWidth == -1) &&
		    	getLayout() == Item.LAYOUT_DEFAULT;
	}

	int getType() {
		return TYPE_GAUGE;
	}

	int getHAlignment() {
		if ((fLayout & Item.LAYOUT_2) != 0) {
			return super.getHAlignment();
		} else {
			return Item.LAYOUT_LEFT;
		}
	}

	ItemComponent getItemComponent() {
		if (fPeer == null) return null;
		return (ItemComponent) fPeer.fParent;
	}
}
